/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.util.NBT;

public class ReactorPartTile
extends AbstractTileEntity<Tier, ReactorBlock> {
    private BlockPos corePos = BlockPos.f_121853_;
    private boolean extractor;
    private boolean built;

    public ReactorPartTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.REACTOR_PART.get(), pos, state, variant);
    }

    public ReactorPartTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag compound) {
        super.readSync(compound);
        this.built = compound.m_128471_("built");
        this.extractor = compound.m_128471_("extractor");
        this.corePos = NBT.readPos(compound, "core_pos");
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound) {
        compound.m_128379_("built", this.built);
        compound.m_128379_("extractor", this.extractor);
        NBT.writePos(compound, this.corePos, "core_pos");
        return super.writeSync(compound);
    }

    public void demolish(Level world) {
        BlockEntity tile = world.m_7702_(this.corePos);
        if (tile instanceof ReactorTile) {
            ReactorTile reactor = (ReactorTile)tile;
            reactor.demolish(world);
        }
    }

    public Optional<ReactorTile> core() {
        BlockEntity tile;
        if (this.f_58857_ != null && (tile = this.f_58857_.m_7702_(this.corePos)) instanceof ReactorTile) {
            return Optional.of((ReactorTile)tile);
        }
        return Optional.empty();
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    public void setCorePos(BlockPos corePos) {
        this.corePos = corePos;
    }

    public void setExtractor(boolean extractor) {
        this.extractor = extractor;
    }

    public boolean isExtractor() {
        return this.extractor;
    }

    public void setBuilt(boolean built) {
        this.built = built;
    }

    public boolean isBuilt() {
        return this.built;
    }
}

