/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerIOControl
implements IItemHandler {
    private IItemHandler itemHandler;
    private InsertCheck insertCheck = null;
    private ExtractCheck extractCheck = null;

    public ItemHandlerIOControl(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    public ItemHandlerIOControl setInsertCheck(InsertCheck insertCheck) {
        this.insertCheck = insertCheck;
        return this;
    }

    public ItemHandlerIOControl setExtractCheck(ExtractCheck extractCheck) {
        this.extractCheck = extractCheck;
        return this;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.insertCheck != null && !this.insertCheck.canInsert(slot, stack)) {
            return stack;
        }
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.extractCheck != null && !this.extractCheck.canExtract(slot, this.itemHandler.getStackInSlot(slot))) {
            return ItemStack.f_41583_;
        }
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    public static interface InsertCheck {
        public boolean canInsert(int var1, ItemStack var2);
    }

    public static interface ExtractCheck {
        public boolean canExtract(int var1, ItemStack var2);
    }
}

