/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ManagedByte
extends AbstractManagedData<Byte> {
    private byte value;
    protected Function<Byte, Byte> validator = null;

    public ManagedByte(String name, int defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = (byte)defaultValue;
    }

    public ManagedByte(String name, DataFlags ... flags) {
        this(name, 0, flags);
    }

    public int set(int value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            byte prev = this.value;
            this.value = (byte)value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners((byte)value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public int get() {
        return this.value;
    }

    public ManagedByte setValidator(Function<Byte, Byte> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeByte((int)this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readByte();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128344_(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128445_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public int add(int add) {
        return this.set((byte)(this.get() + add));
    }

    public int subtract(int subtract) {
        return this.set((byte)(this.get() - subtract));
    }

    public int multiply(int multiplyBy) {
        return this.set((byte)(this.get() * multiplyBy));
    }

    public int divide(int divideBy) {
        return this.set((byte)(this.get() / divideBy));
    }

    public int zero() {
        return this.set(0);
    }

    public int inc() {
        return this.add(1);
    }

    public int dec() {
        return this.subtract(1);
    }
}

