/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldEntitySaveData
extends SavedData {
    public static final String FILE_ID = "brandonscore_world_entity";
    private List<WorldEntity> entities = new ArrayList<WorldEntity>();
    private Runnable saveCallback;

    public void updateEntities(List<WorldEntity> entities) {
        this.entities.clear();
        if (entities != null) {
            this.entities.addAll(entities);
        }
    }

    public void setSaveCallback(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public List<WorldEntity> getEntities() {
        return this.entities;
    }

    public static WorldEntitySaveData load(CompoundTag nbt) {
        WorldEntitySaveData data = new WorldEntitySaveData();
        ListTag list = nbt.m_128437_("entities", 10);
        for (Tag inbt : list) {
            data.entities.add(WorldEntity.readWorldEntity((CompoundTag)inbt));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (WorldEntity entity : this.entities) {
            CompoundTag entityTag = new CompoundTag();
            entity.write(entityTag);
            list.add((Object)entityTag);
        }
        compound.m_128365_("entities", (Tag)list);
        return compound;
    }

    public void m_77757_(File fileIn) {
        this.m_77760_(true);
        this.saveCallback.run();
        super.m_77757_(fileIn);
    }
}

