/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TermiteMoundFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50440_;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() instanceof BushBlock;

    public TermiteMoundFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        if (!this.checkSpace(world, startPos.m_7494_())) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        int height = 2 + rand.m_188503_(3);
        for (int y = -1; y <= height + 1; ++y) {
            this.setBlock(world, pos.m_6630_(y), Blocks.f_220843_.m_49966_());
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x != -1 && x != 1 || z != -1 && z != 1) {
                    int i = height / 2 + (rand.m_188503_(2) - rand.m_188503_(2));
                    for (int y = -1; y <= i; ++y) {
                        this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_220843_.m_49966_());
                    }
                    continue;
                }
                if (rand.m_188503_(3) != 0) continue;
                for (int y = -1; y <= 0; ++y) {
                    this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_220843_.m_49966_());
                }
            }
        }
        int j = 2;
        for (int k = pos.m_123341_() - j; k <= pos.m_123341_() + j; ++k) {
            block7: for (int l = pos.m_123343_() - j; l <= pos.m_123343_() + j; ++l) {
                int j1;
                int i1 = k - pos.m_123341_();
                if (i1 * i1 + (j1 = l - pos.m_123343_()) * j1 > j * j) continue;
                for (int k1 = pos.m_123342_() - 2; k1 <= pos.m_123342_() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = world.m_8055_(blockpos);
                    if (blockstate.m_60734_() != Blocks.f_50440_) continue;
                    world.m_7731_(blockpos, Blocks.f_220843_.m_49966_(), 2);
                    continue block7;
                }
            }
        }
        int m = j + 2;
        for (int k = pos.m_123341_() - m; k <= pos.m_123341_() + m; ++k) {
            block10: for (int l = pos.m_123343_() - m; l <= pos.m_123343_() + m; ++l) {
                int j1;
                int i1 = k - pos.m_123341_();
                if (i1 * i1 + (j1 = l - pos.m_123343_()) * j1 > m * m) continue;
                for (int k1 = pos.m_123342_() - 2; k1 <= pos.m_123342_() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = world.m_8055_(blockpos);
                    if (blockstate.m_60734_() != Blocks.f_50440_) continue;
                    if (rand.m_188503_(2) != 0) continue block10;
                    world.m_7731_(blockpos, Blocks.f_220843_.m_49966_(), 2);
                    continue block10;
                }
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= 6; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAir(LevelSimulatedReader p_65811_, BlockPos p_65812_) {
        return p_65811_.m_7433_(p_65812_, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

