/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.block.entity;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class CapabilityBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public CapabilityBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadPacketNBT(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.savePacketNBT(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.loadPacketNBT(pkt.m_131708_());
        if (this.f_58857_ instanceof ClientLevel) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    public void savePacketNBT(CompoundTag tag) {
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            CompoundTag compound = ((ItemStackHandler)inv).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> tag.m_128365_("energy", ((EnergyStorage)handler).serializeNBT()));
        this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluid -> {
            CompoundTag nbt = new CompoundTag();
            ((FluidTank)fluid).writeToNBT(nbt);
            tag.m_128365_("fluid", (Tag)nbt);
        });
    }

    public void loadPacketNBT(CompoundTag tag) {
        if (tag.m_128441_("inv")) {
            this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> ((ItemStackHandler)inv).deserializeNBT(tag.m_128469_("inv")));
        }
        if (tag.m_128441_("energy")) {
            this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> ((EnergyStorage)handler).deserializeNBT(tag.m_128423_("energy")));
        }
        if (tag.m_128441_("fluid")) {
            this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluid -> ((FluidTank)fluid).readFromNBT(tag.m_128469_("fluid")));
        }
    }
}

