/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.util.GeneratorCreator;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class GeneratorObject {
    private final ResourceLocation id;
    private Supplier<Block> blockSupplier;
    private Supplier<BlockEntityType<GeneratorBlockEntity>> blockEntityType;
    private Supplier<MenuType<GeneratorMenu>> menuType;
    private final GeneratorUtil.FuelType fuelType;
    private final double generationRate;
    private double modifiedGenerationRate = 0.0;
    private final double transferRate;
    private final double consumptionRate;
    private final int bufferCapacity;
    private final boolean hasChargeSlot;
    private final ResourceLocation fuelTag;
    private Map<ResourceLocation, GeneratorCreator.Fuel> fuelList;

    public GeneratorObject(ResourceLocation id, GeneratorUtil.FuelType fuelType, double generationRate, double transferRate, double consumptionRate, int bufferCapacity, boolean hasChargeSlot, ResourceLocation fuelTag) {
        this.id = id;
        this.fuelType = fuelType;
        this.generationRate = generationRate;
        this.transferRate = transferRate;
        this.consumptionRate = consumptionRate;
        this.bufferCapacity = bufferCapacity;
        this.hasChargeSlot = hasChargeSlot;
        this.fuelTag = fuelTag;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Supplier<Block> getBlockSupplier() {
        return this.blockSupplier;
    }

    public void setBlockSupplier(Supplier<Block> blockSupplier) {
        this.blockSupplier = blockSupplier;
    }

    public Supplier<BlockEntityType<GeneratorBlockEntity>> getBlockEntityType() {
        return this.blockEntityType;
    }

    public void setBlockEntityType(Supplier<BlockEntityType<GeneratorBlockEntity>> blockEntityType) {
        this.blockEntityType = blockEntityType;
    }

    public Supplier<MenuType<GeneratorMenu>> getMenuType() {
        return this.menuType;
    }

    public void setMenuType(Supplier<MenuType<GeneratorMenu>> menuType) {
        this.menuType = menuType;
    }

    public GeneratorUtil.FuelType getFuelType() {
        return this.fuelType;
    }

    public double getGenerationRate() {
        return this.modifiedGenerationRate > 0.0 ? this.modifiedGenerationRate : this.generationRate;
    }

    public double getOriginalGenerationRate() {
        return this.generationRate;
    }

    public double getTransferRate() {
        return this.transferRate;
    }

    public double getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean hasChargeSlot() {
        return this.hasChargeSlot;
    }

    public ResourceLocation getFuelTag() {
        return this.fuelTag;
    }

    public static Codec<GeneratorObject> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").orElse((Object)id).forGetter(GeneratorObject::getId), (App)GeneratorUtil.FuelType.CODEC.fieldOf("fuelType").orElse((Object)GeneratorUtil.FuelType.SOLID).forGetter(GeneratorObject::getFuelType), (App)Codec.DOUBLE.fieldOf("generationRate").forGetter(GeneratorObject::getOriginalGenerationRate), (App)Codec.DOUBLE.fieldOf("transferRate").forGetter(GeneratorObject::getTransferRate), (App)Codec.DOUBLE.fieldOf("consumptionRate").forGetter(GeneratorObject::getConsumptionRate), (App)Codec.INT.fieldOf("bufferCapacity").forGetter(GeneratorObject::getBufferCapacity), (App)Codec.BOOL.fieldOf("hasChargeSlot").orElse((Object)true).forGetter(GeneratorObject::hasChargeSlot), (App)ResourceLocation.f_135803_.fieldOf("fuelTag").orElse((Object)GeneratorUtil.EMPTY_TAG).forGetter(GeneratorObject::getFuelTag)).apply((Applicative)instance, GeneratorObject::new));
    }

    public void setGenerationRate(double generationRate) {
        this.modifiedGenerationRate = generationRate;
    }

    public void setFuelList(Map<ResourceLocation, GeneratorCreator.Fuel> fuelList) {
        this.fuelList = fuelList;
    }

    public Map<ResourceLocation, GeneratorCreator.Fuel> getFuelList() {
        return this.fuelList;
    }
}

