/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import cy.jdkdigital.generatorgalore.util.collection.SetMultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionUtil {
    public static final Map<String, Integer> brewingStepCache = new HashMap<String, Integer>();
    private static final SetMultiMap<String, String> potionMap = new SetMultiMap();

    public static SetMultiMap<String, String> getPotionMap() {
        if (potionMap.allValues().isEmpty()) {
            List brewingRecipes = BrewingRecipeRegistry.getRecipes();
            brewingRecipes.stream().filter(VanillaBrewingRecipe.class::isInstance).map(VanillaBrewingRecipe.class::cast).findFirst().ifPresent(vanillaBrewingRecipe -> PotionUtil.addVanillaBrewingRecipes(potionMap, vanillaBrewingRecipe));
            PotionUtil.addModdedBrewingRecipes(brewingRecipes, potionMap);
            brewingStepCache.put(PotionUtil.getUniquePotionName(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)), 0);
        }
        return potionMap;
    }

    private static void addVanillaBrewingRecipes(SetMultiMap<String, String> potionMap, VanillaBrewingRecipe vanillaBrewingRecipe) {
        boolean foundNewPotions;
        List<ItemStack> potionIngredients = ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(PotionBrewing::m_43506_).toList();
        List basePotions = PotionBrewing.f_43496_.stream().flatMap(potionItem -> Arrays.stream(potionItem.m_43908_())).toList();
        ArrayList<ItemStack> knownPotions = new ArrayList<ItemStack>();
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            if (potion == Potions.f_43598_) continue;
            for (ItemStack input : basePotions) {
                ItemStack result = PotionUtils.m_43549_((ItemStack)input.m_41777_(), (Potion)potion);
                knownPotions.add(result);
            }
        }
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = PotionUtil.getNewPotions(knownPotions, potionIngredients, potionMap, vanillaBrewingRecipe)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private static List<ItemStack> getNewPotions(Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, SetMultiMap<String, String> potionMap, VanillaBrewingRecipe vanillaBrewingRecipe) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                ResourceLocation outputId;
                Potion potionInputType;
                ResourceLocation inputId;
                Potion potionOutputType;
                ItemStack potionOutput = vanillaBrewingRecipe.getOutput(potionInput.m_41777_(), potionReagent);
                if (potionOutput.m_41619_() || potionInput.m_41720_() == potionOutput.m_41720_() && ((potionOutputType = PotionUtils.m_43579_((ItemStack)potionOutput)) == Potions.f_43599_ || Objects.equals(inputId = ForgeRegistries.POTIONS.getKey((Object)(potionInputType = PotionUtils.m_43579_((ItemStack)potionInput))), outputId = ForgeRegistries.POTIONS.getKey((Object)potionOutputType)))) continue;
                potionMap.put(PotionUtil.getUniquePotionName(potionOutput), PotionUtil.getUniquePotionName(potionInput));
            }
        }
        return newPotions;
    }

    private static void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, SetMultiMap<String, String> potionMap) {
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            ItemStack[] inputs;
            BrewingRecipe brewingRecipe;
            ItemStack[] ingredients;
            if (!(iBrewingRecipe instanceof BrewingRecipe) || (ingredients = (brewingRecipe = (BrewingRecipe)iBrewingRecipe).getIngredient().m_43908_()).length <= 0) continue;
            Ingredient inputIngredient = brewingRecipe.getInput();
            ItemStack output = brewingRecipe.getOutput();
            for (ItemStack input : inputs = inputIngredient.m_43908_()) {
                potionMap.put(PotionUtil.getUniquePotionName(output), PotionUtil.getUniquePotionName(input));
            }
        }
    }

    public static String getUniquePotionName(ItemStack stack) {
        StringBuilder potionUid = new StringBuilder(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41783_() != null) {
            potionUid.append(stack.m_41783_().m_128461_("Potion"));
        } else {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            potionUid.append(potion.m_43492_(""));
        }
        return potionUid.toString();
    }
}

