/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.tag.EIOTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EntityCaptureUtils {
    private static final ResourceLocation DRAGON = new ResourceLocation("minecraft", "ender_dragon");
    @Nullable
    private static List<ResourceLocation> capturableEntities = null;

    public static List<ResourceLocation> getCapturableEntities() {
        if (capturableEntities == null) {
            ImmutableList livingEntities = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(DefaultAttributes::m_22301_).map(entityType -> entityType).collect(Collectors.toList()));
            ArrayList<ResourceLocation> entities = new ArrayList<ResourceLocation>();
            for (EntityType type : livingEntities) {
                ResourceLocation key;
                if (EntityCaptureUtils.getCapturableStatus((EntityType<? extends LivingEntity>)type, null) != CapturableStatus.CAPTURABLE || (key = ForgeRegistries.ENTITY_TYPES.getKey((Object)type)) == null || key.equals((Object)DRAGON)) continue;
                entities.add(key);
            }
            capturableEntities = ImmutableList.copyOf(entities);
        }
        return capturableEntities;
    }

    public static CapturableStatus getCapturableStatus(EntityType<? extends LivingEntity> type, @Nullable Entity entity) {
        if (entity != null && EntityCaptureUtils.isBlacklistedBoss(entity)) {
            return CapturableStatus.BOSS;
        }
        if (!type.m_20584_()) {
            return CapturableStatus.INCOMPATIBLE;
        }
        if (type.m_204039_(EIOTags.EntityTypes.SOUL_VIAL_BLACKLIST)) {
            return CapturableStatus.BLACKLISTED;
        }
        return CapturableStatus.CAPTURABLE;
    }

    public static boolean isBlacklistedBoss(Entity entity) {
        return entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES);
    }

    public static enum CapturableStatus {
        CAPTURABLE((Component)Component.m_237119_()),
        BOSS(EIOLang.SOUL_VIAL_ERROR_BOSS),
        BLACKLISTED(EIOLang.SOUL_VIAL_ERROR_BLACKLISTED),
        INCOMPATIBLE(EIOLang.SOUL_VIAL_ERROR_FAILED);

        private final Component errorMessage;

        private CapturableStatus(Component errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Component errorMessage() {
            return this.errorMessage;
        }
    }
}

