/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget;

import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.machines.client.gui.widget.EnergyWidget;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CapacitorEnergyWidget
extends EnergyWidget {
    public static final ItemStack CAPACITOR = new ItemStack((ItemLike)EIOItems.BASIC_CAPACITOR.get());
    private final Supplier<Boolean> cap;

    public CapacitorEnergyWidget(Screen displayOn, Supplier<IMachineEnergyStorage> storageSupplier, Supplier<Boolean> cap, int x, int y, int width, int height) {
        super(displayOn, storageSupplier, x, y, width, height);
        this.cap = cap;
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.cap.get().booleanValue()) {
            this.renderCapacitor(guiGraphics);
            if (this.m_198029_()) {
                this.renderCapacitorTooltip(guiGraphics, mouseX, mouseY);
            }
            return;
        }
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderCapacitorTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String[] split;
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(EIOLang.NOCAP_TITLE.m_130940_(ChatFormatting.DARK_AQUA));
        for (String s : split = EIOLang.NOCAP_DESC.getString().split("\n")) {
            list.add(Component.m_237113_((String)s.stripLeading().stripTrailing()));
        }
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 1.0f);
        guiGraphics.m_280666_(this.displayOn.getMinecraft().f_91062_, list, mouseX, mouseY);
        pose.m_85849_();
    }

    public void renderCapacitor(GuiGraphics guiGraphics) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        long tick = level.m_46467_() % 90L;
        int heightModifier = (int)Math.round(Math.sin((double)level.m_46467_() * 0.05) * 12.0);
        guiGraphics.m_280203_(CAPACITOR, this.x - 4, this.y + this.height / 2 - 8 + heightModifier);
        guiGraphics.m_280398_(WIDGETS, this.x, this.y + this.height / 2 + 6, 0, (float)(160L + tick / 10L * 9L), 128.0f, this.width, this.height, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.39215687f);
        RenderSystem.enableBlend();
        guiGraphics.m_280203_(CAPACITOR, this.x - 4, this.y + this.height / 2 + 25);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

