/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EntityPotionFlask
extends ThrowableItemProjectile
implements ItemSupplier {
    public boolean isLingering = false;
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::m_6126_;

    public EntityPotionFlask(EntityType<? extends EntityPotionFlask> typeIn, Level worldIn) {
        super(typeIn, worldIn);
    }

    public EntityPotionFlask(Level worldIn, LivingEntity livingEntityIn) {
        super(EntityType.f_20486_, livingEntityIn, worldIn);
    }

    public EntityPotionFlask(Level worldIn, double x, double y, double z) {
        super(EntityType.f_20486_, x, y, z, worldIn);
    }

    protected Item m_7881_() {
        return Items.f_42736_;
    }

    public void setIsLingering(boolean isLingering) {
        this.isLingering = isLingering;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        if (!this.m_9236_().f_46443_) {
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            boolean flag = potion == Potions.f_43599_ && list.isEmpty();
            Direction direction = p_230299_1_.m_82434_();
            BlockPos blockpos = p_230299_1_.m_82425_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            if (flag) {
                this.extinguishFires(blockpos1, direction);
                this.extinguishFires(blockpos1.m_121945_(direction.m_122424_()), direction);
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.extinguishFires(blockpos1.m_121945_(direction1), direction1);
                }
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            boolean flag;
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
            if (flag) {
                this.applyWater();
            } else if (!list.isEmpty()) {
                if (this.isLingering()) {
                    this.makeAreaOfEffectCloud(itemstack, potion);
                } else {
                    this.applySplash(list, result.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)result).m_82443_() : null);
                }
            }
            int i = potion.m_43491_() ? 2007 : 2002;
            this.m_9236_().m_46796_(i, this.m_20183_(), PotionUtils.m_43575_((ItemStack)itemstack));
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void applyWater() {
        AABB axisalignedbb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.m_9236_().m_6443_(LivingEntity.class, axisalignedbb, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.m_20280_((Entity)livingentity);
                if (!(d0 < 16.0) || !livingentity.m_6126_()) continue;
                livingentity.m_6469_(livingentity.m_269291_().m_269104_((Entity)livingentity, this.m_19749_()), 1.0f);
            }
        }
    }

    private void applySplash(List<MobEffectInstance> p_213888_1_, @Nullable Entity p_213888_2_) {
        AABB axisalignedbb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.m_9236_().m_45976_(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.m_5801_() || !((d0 = this.m_20280_((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == p_213888_2_) {
                    d1 = 1.0;
                }
                for (MobEffectInstance effectinstance : p_213888_1_) {
                    MobEffect effect = effectinstance.m_19544_();
                    if (effect.m_8093_()) {
                        effect.m_19461_((Entity)this, this.m_19749_(), livingentity, effectinstance.m_19564_(), d1);
                        continue;
                    }
                    int i = (int)(d1 * (double)effectinstance.m_19557_() + 0.5);
                    if (i <= 20) continue;
                    livingentity.m_7292_(new MobEffectInstance(effect, i, effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
                }
            }
        }
    }

    public void makeAreaOfEffectCloud(ItemStack p_190542_1_, Potion p_190542_2_) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            areaeffectcloudentity.m_19718_((LivingEntity)entity);
        }
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19732_(-0.5f);
        areaeffectcloudentity.m_19740_(10);
        areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
        areaeffectcloudentity.m_19722_(p_190542_2_);
        for (MobEffectInstance effectinstance : PotionUtils.m_43571_((ItemStack)p_190542_1_)) {
            areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
        }
        CompoundTag compoundnbt = p_190542_1_.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("CustomPotionColor", 99)) {
            areaeffectcloudentity.m_19714_(compoundnbt.m_128451_("CustomPotionColor"));
        }
        this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
    }

    public boolean isLingering() {
        return this.isLingering;
    }

    public void extinguishFires(BlockPos pos, Direction p_184542_2_) {
        BlockState blockstate = this.m_9236_().m_8055_(pos);
        if (blockstate.m_204336_(BlockTags.f_13076_)) {
            this.m_9236_().m_7471_(pos, false);
        } else if (CampfireBlock.m_51319_((BlockState)blockstate)) {
            this.m_9236_().m_5898_((Player)null, 1009, pos, 0);
            CampfireBlock.m_152749_(null, (LevelAccessor)this.m_9236_(), (BlockPos)pos, (BlockState)blockstate);
            this.m_9236_().m_46597_(pos, (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }
}

