/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeAlchemyTable
extends BloodMagicRecipe {
    @Nonnull
    protected final List<Ingredient> input;
    @Nonnull
    private final ItemStack output;
    @Nonnegative
    private final int syphon;
    @Nonnegative
    private final int ticks;
    @Nonnegative
    private final int minimumTier;
    public static final int MAX_INPUTS = 6;

    public RecipeAlchemyTable(ResourceLocation id, List<Ingredient> input, @Nonnull ItemStack output, int syphon, int ticks, int minimumTier) {
        super(id);
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        this.input = input;
        this.output = output;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    @Nonnull
    public List<Ingredient> getInput() {
        return this.input;
    }

    @Nonnull
    public ItemStack getOutput(List<ItemStack> inputs) {
        return this.output;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    public final int getSyphon() {
        return this.syphon;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final int getMinimumTier() {
        return this.minimumTier;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.input.size());
        for (int i = 0; i < this.input.size(); ++i) {
            this.input.get(i).m_43923_(buffer);
        }
        buffer.m_130055_(this.output);
        buffer.writeInt(this.syphon);
        buffer.writeInt(this.ticks);
        buffer.writeInt(this.minimumTier);
    }

    public RecipeSerializer<? extends RecipeAlchemyTable> m_7707_() {
        return BloodMagicRecipeSerializers.ALCHEMYTABLE.getRecipeSerializer();
    }

    public RecipeType<RecipeAlchemyTable> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.ALCHEMYTABLE.get();
    }
}

