/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.AbstractCauldronBlockAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DamageSourceModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IcicleBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TIP_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return IcicleBlock.isValidPosition(levelReader, blockPos);
    }

    public BlockState m_7417_(BlockState currState, Direction neighborDirection, BlockState neighborBlockState, LevelAccessor levelAccessor, BlockPos currPos, BlockPos neighborPos) {
        if (((Boolean)currState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (neighborDirection != Direction.UP && neighborDirection != Direction.DOWN) {
            return currState;
        }
        if (levelAccessor.m_183326_().m_183582_(currPos, (Object)this)) {
            return currState;
        }
        if (neighborDirection == Direction.UP && !this.m_7898_(currState, (LevelReader)levelAccessor, currPos)) {
            levelAccessor.m_186460_(currPos, (Block)this, 2);
            return currState;
        }
        DripstoneThickness thickness = IcicleBlock.calculateIcicleThickness((LevelReader)levelAccessor, currPos);
        return (BlockState)currState.m_61124_(THICKNESS, (Comparable)thickness);
    }

    public void m_5581_(Level level, @NotNull BlockState blockState, BlockHitResult blockHitResult, @NotNull Projectile projectile) {
        BlockPos blockPos = blockHitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockPos) && projectile instanceof AbstractArrow && projectile.m_20184_().m_82553_() > 0.4) {
            level.m_46961_(blockPos, true);
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        IcicleBlock.spawnFallingIcicle(blockState, serverLevel, blockPos);
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        IcicleBlock.maybeFillCauldron(blockState, serverLevel, blockPos, random.m_188501_());
        if (random.m_188501_() < 0.011377778f && IcicleBlock.isTop(blockState, (LevelReader)serverLevel, blockPos)) {
            IcicleBlock.tryToGrowIcicle(blockState, serverLevel, blockPos);
        }
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (!IcicleBlock.canDrip(blockState)) {
            return;
        }
        float chance = random.m_188501_();
        if (chance > 0.12f) {
            return;
        }
        IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(fluid -> chance < 0.02f || IcicleBlock.canFillCauldron(fluid)).ifPresent(fluid -> IcicleBlock.spawnDripParticle(level, blockPos, blockState, fluid));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level levelAccessor = blockPlaceContext.m_43725_();
        if (!IcicleBlock.isValidPosition((LevelReader)levelAccessor, blockPlaceContext.m_8083_())) {
            return null;
        }
        boolean isWaterlogged = levelAccessor.m_6425_(blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        DripstoneThickness thickness = IcicleBlock.calculateIcicleThickness((LevelReader)levelAccessor, blockPlaceContext.m_8083_());
        if (thickness == null) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(THICKNESS, (Comparable)thickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        DripstoneThickness thickness = (DripstoneThickness)blockState.m_61143_(THICKNESS);
        VoxelShape voxelShape = switch (thickness) {
            case DripstoneThickness.BASE -> BASE_SHAPE;
            case DripstoneThickness.MIDDLE -> MIDDLE_SHAPE;
            case DripstoneThickness.FRUSTUM -> FRUSTUM_SHAPE;
            default -> TIP_SHAPE;
        };
        Vec3 vec3 = blockState.m_60824_(blockGetter, blockPos);
        return voxelShape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level level, BlockPos blockPos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.m_20067_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Services.PLATFORM.sendIcicleProjectileShatterS2CPacket(serverLevel, Vec3.m_82512_((Vec3i)blockPos));
            fallingBlockEntity.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (new Random().nextFloat() * 0.2f + 0.9f));
        }
    }

    @NotNull
    public DamageSource m_252932_(@NotNull Entity entity) {
        return DamageSourceModule.FALLING_ICICLE;
    }

    @NotNull
    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    @Nullable
    private static BlockPos findTip(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, int searchDistance) {
        if (IcicleBlock.isTip(blockState)) {
            return blockPos;
        }
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, Direction.DOWN, state -> state.m_60713_((Block)BlockModule.ICICLE.get()), IcicleBlock::isTip, searchDistance).orElse(null);
    }

    @Nullable
    private static BlockPos findRoot(LevelAccessor levelAccessor, BlockPos blockPos) {
        Predicate<BlockState> matchingPredicate = state -> state.m_60713_((Block)BlockModule.ICICLE.get());
        Predicate<BlockState> stoppingPredicate = state -> !state.m_60713_((Block)BlockModule.ICICLE.get());
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, Direction.UP, matchingPredicate, stoppingPredicate, 11).orElse(null);
    }

    private static boolean isValidPosition(LevelReader levelReader, BlockPos blockPos) {
        BlockPos posAbove = blockPos.m_121945_(Direction.UP);
        BlockState blockStateAbove = levelReader.m_8055_(posAbove);
        return blockStateAbove.m_60783_((BlockGetter)levelReader, posAbove, Direction.DOWN) || blockStateAbove.m_60713_((Block)BlockModule.ICICLE.get());
    }

    private static boolean isTip(BlockState blockState) {
        if (!blockState.m_60713_((Block)BlockModule.ICICLE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)blockState.m_61143_(THICKNESS);
        return thickness == DripstoneThickness.TIP;
    }

    private static boolean isTop(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return blockState.m_60713_((Block)BlockModule.ICICLE.get()) && !levelReader.m_8055_(blockPos.m_7494_()).m_60713_((Block)BlockModule.ICICLE.get());
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor levelAccessor, BlockPos startPos, Direction searchDirection, Predicate<BlockState> predicate, Predicate<BlockState> stoppingPredicate, int searchDistance) {
        BlockPos.MutableBlockPos mutable = startPos.m_122032_();
        for (int i = 1; i < searchDistance; ++i) {
            mutable.m_122173_(searchDirection);
            BlockState blockState = levelAccessor.m_8055_((BlockPos)mutable);
            if (stoppingPredicate.test(blockState)) {
                return Optional.of(mutable.m_7949_());
            }
            if (predicate.test(blockState) && !levelAccessor.m_151562_(mutable.m_123342_())) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static DripstoneThickness calculateIcicleThickness(LevelReader levelReader, BlockPos blockPos) {
        BlockState blockBelow = levelReader.m_8055_(blockPos.m_121945_(Direction.DOWN));
        BlockState blockAbove = levelReader.m_8055_(blockPos.m_121945_(Direction.UP));
        if (!blockBelow.m_60713_((Block)BlockModule.ICICLE.get())) {
            return DripstoneThickness.TIP;
        }
        if (blockBelow.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            return DripstoneThickness.FRUSTUM;
        }
        if (!blockAbove.m_60713_((Block)BlockModule.ICICLE.get())) {
            return DripstoneThickness.BASE;
        }
        return DripstoneThickness.MIDDLE;
    }

    private static void spawnFallingIcicle(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        BlockState blockState2 = blockState;
        while (blockState2.m_60713_((Block)BlockModule.ICICLE.get())) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)mutable, (BlockState)blockState2);
            if (IcicleBlock.isTip(blockState2)) {
                int icicleSize = Math.max(1 + blockPos.m_123342_() - mutable.m_123342_(), 6);
                float damagePerBlock = 0.5f * (float)icicleSize;
                fallingBlockEntity.m_149656_(damagePerBlock, 10);
                break;
            }
            mutable.m_122173_(Direction.DOWN);
            blockState2 = serverLevel.m_8055_((BlockPos)mutable);
        }
    }

    private static void tryToGrowIcicle(BlockState rootIcicleBlock, ServerLevel serverLevel, BlockPos rootIcicleBlockPos) {
        if (!IcicleBlock.canGrow(serverLevel.m_8055_(rootIcicleBlockPos.m_6630_(1)), serverLevel.m_8055_(rootIcicleBlockPos.m_6630_(2)))) {
            return;
        }
        BlockPos tipPos = IcicleBlock.findTip(rootIcicleBlock, (LevelAccessor)serverLevel, rootIcicleBlockPos, 6);
        if (tipPos == null || !IcicleBlock.isTip(serverLevel.m_8055_(tipPos))) {
            return;
        }
        if (IcicleBlock.doesTipHaveRoomToGrow(serverLevel, tipPos)) {
            IcicleBlock.growIcicle(serverLevel, tipPos);
        }
    }

    private static boolean canGrow(BlockState blockState, BlockState blockStateAbove) {
        return blockState.m_204336_(BlockTags.f_13047_) && blockStateAbove.m_60713_(Blocks.f_49990_) && blockStateAbove.m_60819_().m_76170_();
    }

    private static boolean doesTipHaveRoomToGrow(ServerLevel serverLevel, BlockPos tipPos) {
        BlockPos belowTipPos = tipPos.m_121945_(Direction.DOWN);
        BlockState belowTipBlock = serverLevel.m_8055_(belowTipPos);
        if (!belowTipBlock.m_60819_().m_76178_()) {
            return false;
        }
        return belowTipBlock.m_60795_();
    }

    private static void growIcicle(ServerLevel serverLevel, BlockPos tipPos) {
        BlockPos belowTipBlock = tipPos.m_7495_();
        IcicleBlock.createIcicle((LevelAccessor)serverLevel, belowTipBlock, DripstoneThickness.TIP);
    }

    private static void createIcicle(LevelAccessor levelAccessor, BlockPos blockPos, DripstoneThickness thickness) {
        BlockState blockState = (BlockState)((BlockState)((Block)BlockModule.ICICLE.get()).m_49966_().m_61124_(THICKNESS, (Comparable)thickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
        levelAccessor.m_7731_(blockPos, blockState, 3);
    }

    @Nullable
    public static BlockPos findIcicleTipAboveCauldron(Level level, BlockPos blockPos) {
        return IcicleBlock.findBlockVertical((LevelAccessor)level, blockPos, Direction.UP, BlockBehaviour.BlockStateBase::m_60795_, IcicleBlock::canDrip, 11).orElse(null);
    }

    private static boolean canDrip(BlockState blockState) {
        return blockState.m_60734_() == BlockModule.ICICLE.get() && blockState.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    private static Optional<Fluid> getFluidAboveIcicle(Level level, BlockPos blockPos) {
        BlockPos rootPos = IcicleBlock.findRoot((LevelAccessor)level, blockPos);
        if (rootPos == null) {
            return Optional.empty();
        }
        return Optional.of(level.m_6425_(rootPos.m_7494_()).m_76152_());
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }

    private static void spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Vec3 vec3 = blockState.m_60824_((BlockGetter)level, blockPos);
        double d = 0.0625;
        double x = (double)blockPos.m_123341_() + 0.5 + vec3.f_82479_;
        double y = (double)((float)(blockPos.m_123342_() + 1) - 0.6875f) - d;
        double z = (double)blockPos.m_123343_() + 0.5 + vec3.f_82481_;
        level.m_7106_((ParticleOptions)ParticleTypes.f_175824_, x, y, z, 0.0, 0.0, 0.0);
    }

    public static Fluid getCauldronFillFluidType(Level level, BlockPos blockPos) {
        return IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(IcicleBlock::canFillCauldron).orElse(null);
    }

    private static void maybeFillCauldron(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, float f) {
        if (f > 0.17578125f) {
            return;
        }
        if (!IcicleBlock.isTop(blockState, (LevelReader)serverLevel, blockPos)) {
            return;
        }
        Fluid fluid = IcicleBlock.getCauldronFillFluidType((Level)serverLevel, blockPos);
        if (fluid != Fluids.f_76193_) {
            return;
        }
        float dripChance = 0.17578125f;
        if (f >= dripChance) {
            return;
        }
        BlockPos tipPos = IcicleBlock.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 11);
        if (tipPos == null) {
            return;
        }
        Predicate<BlockState> isValidCauldron = state -> state.m_60734_() instanceof AbstractCauldronBlock && ((AbstractCauldronBlockAccessor)state.m_60734_()).callCanReceiveStalactiteDrip(fluid);
        BlockPos cauldronPos = IcicleBlock.findBlockVertical((LevelAccessor)serverLevel, tipPos, Direction.DOWN, BlockBehaviour.BlockStateBase::m_60795_, isValidCauldron, 11).orElse(null);
        if (cauldronPos == null) {
            return;
        }
        int yDist = tipPos.m_123342_() - cauldronPos.m_123342_();
        int timeUntilCauldronTick = 50 + yDist;
        BlockState cauldronBlockState = serverLevel.m_8055_(cauldronPos);
        serverLevel.m_186460_(cauldronPos, cauldronBlockState.m_60734_(), timeUntilCauldronTick);
    }
}

