/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SimpleModuleHost
implements ModuleHost {
    private static final Logger LOGGER = LogManager.getLogger(SimpleModuleHost.class);
    private final int gridWidth;
    private final int gridHeight;
    private final boolean deleteInvalidModules;
    private final TechLevel techLevel;
    private final List<ModuleEntity<?>> moduleEntities = new ArrayList();
    private final Set<ModuleType<?>> additionalTypeList = new HashSet();
    private final Set<ModuleType<?>> typeBlackList = new HashSet();
    private final Set<ModuleCategory> categories = new HashSet<ModuleCategory>();
    private final Map<ModuleType<?>, ModuleData<?>> moduleDataCache = new HashMap();
    private BiFunction<ModuleEntity<?>, List<Component>, Boolean> removeCheck = null;

    public SimpleModuleHost(TechLevel techLevel, int gridWidth, int gridHeight, boolean deleteInvalidModules, ModuleCategory ... categories) {
        this.techLevel = techLevel;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.deleteInvalidModules = deleteInvalidModules;
        this.categories.addAll(Arrays.asList(categories));
    }

    public void setEntityRemoveListener(BiFunction<ModuleEntity<?>, List<Component>, Boolean> removeListener) {
        this.removeCheck = removeListener;
    }

    @Override
    public Stream<Module<?>> getModules() {
        return this.getModuleEntities().stream().map(ModuleEntity::getModule);
    }

    @Override
    public List<ModuleEntity<?>> getModuleEntities() {
        return Collections.unmodifiableList(this.moduleEntities);
    }

    @Override
    public void addModule(ModuleEntity<?> entity, ModuleContext context) {
        this.moduleEntities.add(entity);
        entity.setHost(this);
        this.clearCaches();
        entity.onInstalled(context);
    }

    @Override
    public void removeModule(ModuleEntity<?> entity, ModuleContext context) {
        this.moduleEntities.remove(entity);
        this.clearCaches();
        entity.onRemoved(context);
    }

    @Override
    public Collection<ModuleCategory> getModuleCategories() {
        return this.categories;
    }

    public SimpleModuleHost addCategories(ModuleCategory ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public Collection<ModuleType<?>> getAdditionalTypes() {
        return this.additionalTypeList;
    }

    @Override
    public Collection<ModuleType<?>> getTypeBlackList() {
        return this.typeBlackList;
    }

    public SimpleModuleHost addAdditionalType(ModuleType<?> type) {
        this.additionalTypeList.add(type);
        return this;
    }

    public SimpleModuleHost blackListType(ModuleType<?> type) {
        this.typeBlackList.add(type);
        return this;
    }

    @Override
    public TechLevel getHostTechLevel() {
        return this.techLevel;
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public void handleTick(ModuleContext context) {
        this.getModuleEntities().forEach(e -> e.tick(context));
    }

    @Override
    @Nullable
    public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType) {
        return (T)this.moduleDataCache.computeIfAbsent(moduleType, x$0 -> ModuleHost.super.getModuleData(x$0));
    }

    @Override
    public boolean checkRemoveModule(ModuleEntity<?> module, List<Component> reason) {
        return this.removeCheck == null || this.removeCheck.apply(module, reason) != false;
    }

    private void clearCaches() {
        this.moduleDataCache.clear();
        this.getModuleEntities().forEach(ModuleEntity::clearCaches);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag modules = new ListTag();
        for (ModuleEntity<?> entity : this.moduleEntities) {
            CompoundTag entityNBT = new CompoundTag();
            entityNBT.m_128359_("id", DEModules.REGISTRY.getKey(entity.module).toString());
            entity.writeToNBT(entityNBT);
            modules.add((Object)entityNBT);
        }
        nbt.m_128365_("modules", (Tag)modules);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.clearCaches();
        this.moduleEntities.clear();
        ListTag modules = nbt.m_128437_("modules", 10);
        modules.stream().map(inbt -> (CompoundTag)inbt).forEach(compound -> {
            ResourceLocation id = new ResourceLocation(compound.m_128461_("id"));
            Module module = (Module)ModuleRegistry.getRegistry().getValue(id);
            if (module == null) {
                LOGGER.warn("Failed to load unregistered module: " + id + " Skipping...");
            } else {
                ModuleEntity<?> entity = module.createEntity();
                entity.readFromNBT((CompoundTag)compound);
                if (this.deleteInvalidModules && !entity.isPosValid(this.gridWidth, this.gridHeight)) {
                    LOGGER.warn("Deleting module from invalid grid position: " + entity.toString());
                } else {
                    this.moduleEntities.add(entity);
                    entity.setHost(this);
                }
            }
        });
    }
}

