/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.EnumProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;

public class PropertyData {
    public final ConfigProperty.Type type;
    public final UUID providerID;
    public final String providerName;
    private String propName;
    protected UUID propUniqueName;
    public Component toolTip;
    public Component displayName;
    public Runnable changeListener;
    public boolean isGlobal = false;
    private boolean isPropertyAvailable = false;
    public boolean isProviderAvailable = false;
    public int integerValue = 0;
    public double decimalValue = 0.0;
    public String displayValue = "value";
    public boolean booleanValue = false;
    public double minValue = 0.0;
    public double maxValue = 1.0;
    public ConfigProperty.BooleanFormatter booleanFormatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    public ConfigProperty.IntegerFormatter integerFormatter = ConfigProperty.IntegerFormatter.RAW;
    public ConfigProperty.DecimalFormatter decimalFormatter = ConfigProperty.DecimalFormatter.RAW_1;
    public int enumValueIndex = 0;
    public List<Integer> enumValueOptions;
    public Map<Integer, String> enumDisplayValues;

    public PropertyData(PropertyProvider provider, ConfigProperty property, boolean pullValue) {
        this(provider.getProviderID(), provider.getProviderName(), property.getType());
        this.displayName = property.getDisplayName();
        this.toolTip = property.getToolTip();
        if (property.getUniqueName() != null) {
            this.propUniqueName = property.getUniqueName();
        } else {
            this.propName = property.getName();
        }
        this.isProviderAvailable = true;
        this.pullData(property, pullValue);
    }

    public PropertyData(UUID providerID, String providerName, ConfigProperty.Type type) {
        this.providerID = providerID;
        this.providerName = providerName;
        this.type = type;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void pullData(ConfigProperty property, boolean pullValue) {
        boolean bl = this.isPropertyAvailable = property != null;
        if (this.isPropertyAvailable) {
            TranslatableContents tra;
            ComponentContents componentContents;
            this.displayName = property.getDisplayName();
            this.toolTip = property.getToolTip();
            if (this.toolTip != null && (componentContents = this.toolTip.m_214077_()) instanceof TranslatableContents && (tra = (TranslatableContents)componentContents).m_237508_().equals(this.toolTip.getString())) {
                this.toolTip = null;
            }
            this.displayValue = property.getDisplayValue();
            switch (property.getType()) {
                case BOOLEAN: {
                    ConfigProperty prop = (BooleanProperty)property;
                    this.booleanFormatter = ((BooleanProperty)prop).getFormatter();
                    if (!pullValue) break;
                    this.booleanValue = ((BooleanProperty)prop).getValue();
                    break;
                }
                case INTEGER: {
                    ConfigProperty prop = (IntegerProperty)property;
                    this.integerFormatter = ((IntegerProperty)prop).getFormatter();
                    this.minValue = ((IntegerProperty)prop).getMin();
                    this.maxValue = ((IntegerProperty)prop).getMax();
                    if (!pullValue) break;
                    this.integerValue = ((IntegerProperty)prop).getValue();
                    break;
                }
                case DECIMAL: {
                    ConfigProperty prop = (DecimalProperty)property;
                    this.decimalFormatter = ((DecimalProperty)prop).getFormatter();
                    this.minValue = ((DecimalProperty)prop).getMin();
                    this.maxValue = ((DecimalProperty)prop).getMax();
                    if (!pullValue) break;
                    this.decimalValue = ((DecimalProperty)prop).getValue();
                    break;
                }
                case ENUM: {
                    ConfigProperty prop = (EnumProperty)property;
                    this.enumValueOptions = ((EnumProperty)prop).getAllowedValues().stream().map(Enum::ordinal).collect(Collectors.toList());
                    this.enumDisplayValues = ((EnumProperty)prop).generateValueDisplayMap();
                    if (!pullValue) break;
                    this.enumValueIndex = ((Enum)((EnumProperty)prop).getValue()).ordinal();
                }
            }
        }
        this.updateDisplayValue();
    }

    public String getPropertyName() {
        return this.propUniqueName == null ? this.propName : this.propUniqueName.toString();
    }

    public void pullData(ConfigurableItemMenu container, boolean pullValue) {
        PropertyProvider provider = container.findProvider(this.providerID);
        boolean bl = this.isProviderAvailable = provider != null;
        if (this.isProviderAvailable) {
            this.pullData(provider.getProperty(this.getPropertyName()), pullValue);
        }
    }

    public void updateDisplayValue() {
        switch (this.type) {
            case BOOLEAN: {
                if (this.booleanFormatter == null) break;
                this.displayValue = this.booleanFormatter.format(this.booleanValue);
                break;
            }
            case INTEGER: {
                if (this.integerFormatter == null) break;
                this.displayValue = this.integerFormatter.format(this.integerValue);
                break;
            }
            case DECIMAL: {
                if (this.decimalFormatter == null) break;
                this.displayValue = this.decimalFormatter.format(this.decimalValue);
                break;
            }
            case ENUM: {
                if (this.enumDisplayValues == null) break;
                this.displayValue = this.enumDisplayValues.getOrDefault(this.enumValueIndex, "[Error]");
            }
        }
    }

    public void updateBooleanValue(boolean newValue) {
        if (this.type == ConfigProperty.Type.BOOLEAN) {
            this.booleanValue = newValue;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void toggleBooleanValue() {
        this.updateBooleanValue(!this.booleanValue);
    }

    public void updateEnumValue(int newIndex) {
        if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions.contains(newIndex)) {
            this.enumValueIndex = newIndex;
            this.updateDisplayValue();
            this.onValueChanged();
        }
    }

    public void updateNumberValue(double value, boolean isFinalValue) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            this.integerValue = (int)Math.round(value);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            this.decimalValue = value;
        } else {
            return;
        }
        this.updateDisplayValue();
        if (isFinalValue) {
            this.onValueChanged();
        }
    }

    public void increment(int dir) {
        if (this.type == ConfigProperty.Type.INTEGER) {
            int inc = (int)(Math.max(1.0, this.getInc(this.maxValue - this.minValue)) * (double)dir * (double)(Screen.m_96638_() ? 2 : 1));
            this.integerValue = (int)MathHelper.clip((double)(this.integerValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.DECIMAL) {
            double inc = this.getInc(this.maxValue - this.minValue) * (double)dir * (double)(Screen.m_96638_() ? 2 : 1);
            this.decimalValue = MathHelper.clip((double)(this.decimalValue + inc), (double)this.minValue, (double)this.maxValue);
        } else if (this.type == ConfigProperty.Type.ENUM && this.enumValueOptions != null && this.enumValueOptions.contains(this.enumValueIndex)) {
            int index = this.enumValueOptions.indexOf(this.enumValueIndex);
            int newIndex = Math.floorMod(index + dir, this.enumValueOptions.size());
            this.enumValueIndex = this.enumValueOptions.get(newIndex);
        } else {
            return;
        }
        this.updateDisplayValue();
        this.onValueChanged();
    }

    private double getInc(double range) {
        if (range <= 1.0) {
            return 0.1;
        }
        if (range <= 5.0) {
            return 0.5;
        }
        if (range <= 10.0) {
            return 1.0;
        }
        if (range <= 20.0) {
            return 2.0;
        }
        if (range <= 50.0) {
            return 5.0;
        }
        return 10.0;
    }

    public void onValueChanged() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void toggleGlobal() {
        this.isGlobal = !this.isGlobal;
    }

    public String getEnumDisplayName(int enumIndex) {
        return this.enumDisplayValues != null && this.enumDisplayValues.containsKey(enumIndex) ? this.enumDisplayValues.get(enumIndex) : ChatFormatting.RED + "[Error]";
    }

    public void sendToServer() {
        DraconicNetwork.sendPropertyData(this);
    }

    public ConfigProperty getPropIfApplicable(PropertyProvider provider) {
        if (provider.getProviderName().equals(this.providerName) && (this.isGlobal || provider.getProviderID().equals(this.providerID))) {
            return provider.getProperty(this.getPropertyName());
        }
        return null;
    }

    public boolean doesDataMatch(ConfigProperty prop) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigProperty.Type.BOOLEAN -> {
                if (prop instanceof BooleanProperty && ((BooleanProperty)prop).getValue() == this.booleanValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.INTEGER -> {
                if (prop instanceof IntegerProperty && ((IntegerProperty)prop).getValue() == this.integerValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.DECIMAL -> {
                if (prop instanceof DecimalProperty && ((DecimalProperty)prop).getValue() == this.decimalValue) {
                    yield true;
                }
                yield false;
            }
            case ConfigProperty.Type.ENUM -> prop instanceof EnumProperty && ((Enum)((EnumProperty)prop).getValue()).ordinal() == this.enumValueIndex;
        };
    }

    public boolean isPropertyAvailable() {
        return this.isPropertyAvailable && this.isProviderAvailable;
    }

    public PropertyData copy() {
        PropertyData copy = new PropertyData(this.providerID, this.providerName, this.type);
        copy.propName = this.propName;
        copy.propUniqueName = this.propUniqueName;
        copy.toolTip = this.toolTip;
        copy.displayName = this.displayName;
        copy.changeListener = this.changeListener;
        copy.isGlobal = this.isGlobal;
        copy.isPropertyAvailable = this.isPropertyAvailable;
        copy.isProviderAvailable = this.isProviderAvailable;
        copy.integerValue = this.integerValue;
        copy.decimalValue = this.decimalValue;
        copy.displayValue = this.displayValue;
        copy.booleanValue = this.booleanValue;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.booleanFormatter = this.booleanFormatter;
        copy.integerFormatter = this.integerFormatter;
        copy.decimalFormatter = this.decimalFormatter;
        copy.enumValueIndex = this.enumValueIndex;
        if (this.enumValueOptions != null && this.enumDisplayValues != null) {
            copy.enumValueOptions = new ArrayList<Integer>(this.enumValueOptions);
            copy.enumDisplayValues = new HashMap<Integer, String>(this.enumDisplayValues);
        }
        return copy;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("type", (byte)this.type.ordinal());
        nbt.m_128362_("prov_id", this.providerID);
        nbt.m_128359_("prov_name", this.providerName);
        if (this.propUniqueName != null) {
            nbt.m_128362_("prop_name", this.propUniqueName);
        } else {
            nbt.m_128359_("prop_name", this.propName);
        }
        nbt.m_128359_("tooltip", Component.Serializer.m_130703_((Component)this.toolTip));
        nbt.m_128359_("display_name", Component.Serializer.m_130703_((Component)this.displayName));
        nbt.m_128359_("display_value", this.displayValue);
        nbt.m_128379_("global", this.isGlobal);
        switch (this.type) {
            case BOOLEAN: {
                nbt.m_128379_("value", this.booleanValue);
                nbt.m_128344_("formatter", (byte)this.booleanFormatter.ordinal());
                break;
            }
            case INTEGER: {
                nbt.m_128405_("value", this.integerValue);
                nbt.m_128344_("formatter", (byte)this.integerFormatter.ordinal());
                nbt.m_128405_("min", (int)this.minValue);
                nbt.m_128405_("max", (int)this.maxValue);
                break;
            }
            case DECIMAL: {
                nbt.m_128347_("value", this.decimalValue);
                nbt.m_128344_("formatter", (byte)this.decimalFormatter.ordinal());
                nbt.m_128347_("min", this.minValue);
                nbt.m_128347_("max", this.maxValue);
                break;
            }
            case ENUM: {
                nbt.m_128405_("value", this.enumValueIndex);
                if (this.enumValueOptions != null) {
                    nbt.m_128365_("names", (Tag)this.enumValueOptions.stream().map(IntTag::m_128679_).collect(Collectors.toCollection(ListTag::new)));
                }
                if (this.enumDisplayValues == null) break;
                CompoundTag nameValues = new CompoundTag();
                this.enumDisplayValues.forEach((key, value) -> nameValues.m_128359_(String.valueOf(key), value));
                nbt.m_128365_("name_values", (Tag)nameValues);
            }
        }
        return nbt;
    }

    @Nullable
    public static PropertyData deserialize(CompoundTag nbt) {
        if (!(nbt.m_128403_("prov_id") && nbt.m_128441_("prov_name") && (nbt.m_128441_("prop_name") || nbt.m_128403_("prop_name")) && nbt.m_128441_("type"))) {
            return null;
        }
        PropertyData data = new PropertyData(nbt.m_128342_("prov_id"), nbt.m_128461_("prov_name"), ConfigProperty.Type.getSafe(nbt.m_128445_("type")));
        if (nbt.m_128403_("prop_name")) {
            data.propUniqueName = nbt.m_128342_("prop_name");
        } else {
            data.propName = nbt.m_128461_("prop_name");
        }
        try {
            data.toolTip = Component.Serializer.m_130714_((String)nbt.m_128461_("tooltip"));
        }
        catch (JsonParseException ignored) {
            data.toolTip = Component.m_237113_((String)nbt.m_128461_("tooltip"));
        }
        try {
            data.displayName = Component.Serializer.m_130714_((String)nbt.m_128461_("display_name"));
        }
        catch (JsonParseException ignored) {
            data.displayName = Component.m_237113_((String)nbt.m_128461_("display_name"));
        }
        data.displayValue = nbt.m_128461_("display_value");
        data.isGlobal = nbt.m_128471_("global");
        switch (data.type) {
            case BOOLEAN: {
                data.booleanValue = nbt.m_128471_("value");
                data.booleanFormatter = ConfigProperty.BooleanFormatter.getSafe(nbt.m_128445_("formatter"));
                break;
            }
            case INTEGER: {
                data.integerValue = nbt.m_128451_("value");
                data.integerFormatter = ConfigProperty.IntegerFormatter.getSafe(nbt.m_128445_("formatter"));
                data.minValue = nbt.m_128451_("min");
                data.maxValue = nbt.m_128451_("max");
                break;
            }
            case DECIMAL: {
                data.decimalValue = nbt.m_128459_("value");
                data.decimalFormatter = ConfigProperty.DecimalFormatter.getSafe(nbt.m_128445_("formatter"));
                data.minValue = nbt.m_128459_("min");
                data.maxValue = nbt.m_128459_("max");
                break;
            }
            case ENUM: {
                data.enumValueIndex = nbt.m_128451_("value");
                if (nbt.m_128441_("names")) {
                    data.enumValueOptions = nbt.m_128437_("names", 3).stream().map(inbt -> ((IntTag)inbt).m_7047_()).collect(Collectors.toList());
                }
                if (!nbt.m_128441_("name_values")) break;
                CompoundTag nameValues = nbt.m_128469_("name_values");
                data.enumDisplayValues = nameValues.m_128431_().stream().collect(Collectors.toMap(Utils::parseInt, arg_0 -> ((CompoundTag)nameValues).m_128461_(arg_0)));
            }
        }
        return data;
    }

    public void write(MCDataOutput output) {
        output.writeEnum((Enum)this.type);
        output.writeBoolean(this.isGlobal);
        if (!this.isGlobal) {
            output.writeUUID(this.providerID);
        }
        output.writeString(this.providerName);
        output.writeBoolean(this.propUniqueName != null);
        if (this.propUniqueName != null) {
            output.writeUUID(this.propUniqueName);
        } else {
            output.writeString(this.propName);
        }
        switch (this.type) {
            case BOOLEAN: {
                output.writeBoolean(this.booleanValue);
                break;
            }
            case INTEGER: {
                output.writeVarInt(this.integerValue);
                break;
            }
            case DECIMAL: {
                output.writeDouble(this.decimalValue);
                break;
            }
            case ENUM: {
                output.writeVarInt(this.enumValueIndex);
            }
        }
    }

    public static PropertyData read(MCDataInput input) {
        ConfigProperty.Type type = (ConfigProperty.Type)input.readEnum(ConfigProperty.Type.class);
        boolean isGlobal = input.readBoolean();
        UUID provID = isGlobal ? null : input.readUUID();
        String provName = input.readString();
        PropertyData data = new PropertyData(provID, provName, type);
        if (input.readBoolean()) {
            data.propUniqueName = input.readUUID();
        } else {
            data.propName = input.readString();
        }
        data.isGlobal = isGlobal;
        switch (type) {
            case BOOLEAN: {
                data.booleanValue = input.readBoolean();
                break;
            }
            case INTEGER: {
                data.integerValue = input.readVarInt();
                break;
            }
            case DECIMAL: {
                data.decimalValue = input.readDouble();
                break;
            }
            case ENUM: {
                data.enumValueIndex = input.readVarInt();
            }
        }
        return data;
    }
}

