/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.tleveling.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.redfox.tleveling.leveling.ToolLevel;
import net.redfox.tleveling.leveling.ToolLeveling;
import net.redfox.tleveling.util.MathHandler;
import net.redfox.tleveling.util.ModTags;

public class LevelupCommand {
    public LevelupCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tleveling").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"levelup").executes(LevelupCommand::levelup)));
    }

    private static int levelup(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_230896_();
        if (player == null) {
            return -1;
        }
        ItemStack stack = player.m_21205_();
        if (!stack.m_204117_(ModTags.Items.ALL_TOOLS)) {
            source.m_81352_((Component)Component.m_237113_((String)"This item cannot level up!"));
            return -1;
        }
        if (ToolLevel.TOOL_LEVELS[stack.m_41784_().m_128451_("toolLevel")].isMaxLevel()) {
            source.m_81352_((Component)Component.m_237113_((String)"This item has reached the maximum level!"));
            return -1;
        }
        ToolLevel level = ToolLevel.TOOL_LEVELS[stack.m_41784_().m_128451_("toolLevel")];
        int requiredExp = MathHandler.getRequiredExp(level.getLevel());
        stack.m_41784_().m_128347_("toolExp", (double)requiredExp);
        new ToolLeveling((Player)source.m_230896_());
        source.m_243053_((Component)Component.m_237113_((String)"Tool successfully leveled up."));
        return 1;
    }
}

