/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.data.datamap.BlockStateDataMapLoader;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.Vector3fLoadable;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public class FluidCuboid {
    protected static final Map<Direction, FluidFace> DEFAULT_FACES = new EnumMap<Direction, FluidFace>(Direction.class);
    public static final RecordLoadable<FluidCuboid> LOADABLE;
    public static final Loadable<List<FluidCuboid>> LIST_LOADABLE;
    public static final BlockStateDataMapLoader<List<FluidCuboid>> REGISTRY;
    private final Vector3f from;
    private final Vector3f to;
    private final Map<Direction, FluidFace> faces;
    @Nullable
    private Vector3f fromScaled;
    @Nullable
    private Vector3f toScaled;

    @Nullable
    public FluidFace getFace(Direction face) {
        return this.faces.get(face);
    }

    public Vector3f getFromScaled() {
        if (this.fromScaled == null) {
            this.fromScaled = new Vector3f((Vector3fc)this.from);
            this.fromScaled.mul(0.0625f);
        }
        return this.fromScaled;
    }

    public Vector3f getToScaled() {
        if (this.toScaled == null) {
            this.toScaled = new Vector3f((Vector3fc)this.to);
            this.toScaled.mul(0.0625f);
        }
        return this.toScaled;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected FluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidFace> faces) {
        this.from = from;
        this.to = to;
        this.faces = faces;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Map<Direction, FluidFace> getFaces() {
        return this.faces;
    }

    static {
        for (Direction direction : Direction.values()) {
            DEFAULT_FACES.put(direction, FluidFace.NORMAL);
        }
        LOADABLE = RecordLoadable.create(Vector3fLoadable.INSTANCE.requiredField("from", FluidCuboid::getFrom), Vector3fLoadable.INSTANCE.requiredField("to", FluidCuboid::getTo), Loadables.DIRECTION.mapWithValues(FluidFace.LOADABLE, 1).defaultField("faces", DEFAULT_FACES, FluidCuboid::getFaces), FluidCuboid::new);
        LIST_LOADABLE = LOADABLE.list(-1);
        REGISTRY = new BlockStateDataMapLoader<List<FluidCuboid>>("Block entity fluids", "mantle/model/block_fluids", LIST_LOADABLE);
    }

    public record FluidFace(boolean isFlowing, int rotation) {
        public static final FluidFace NORMAL = new FluidFace(false, 0);
        public static final RecordLoadable<FluidFace> LOADABLE = RecordLoadable.create(BooleanLoadable.INSTANCE.defaultField("flowing", false, false, FluidFace::isFlowing), Loadables.ROTATION.defaultField("rotation", 0, FluidFace::rotation), FluidFace::new);

        public FluidFace {
            if (!ModelHelper.checkRotation(rotation)) {
                throw new IllegalArgumentException("Rotation must be 0/90/180/270");
            }
        }
    }

    public static class Builder {
        private Vector3f from = new Vector3f(0.0f, 0.0f, 0.0f);
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private final Map<Direction, FluidFace> faces = new EnumMap<Direction, FluidFace>(Direction.class);

        public Builder from(float x, float y, float z) {
            this.from = new Vector3f(x, y, z);
            return this;
        }

        public Builder to(float x, float y, float z) {
            this.to = new Vector3f(x, y, z);
            return this;
        }

        private Builder face(Direction direction, FluidFace face) {
            FluidFace oldFace = this.faces.putIfAbsent(direction, face);
            if (oldFace != null) {
                throw new IllegalArgumentException("Duplicate face for " + direction + ", original " + oldFace + ", new " + face);
            }
            return this;
        }

        public Builder face(boolean flowing, int rotation, Direction direction, Direction ... others) {
            FluidFace face = new FluidFace(flowing, rotation);
            for (Direction other : others) {
                this.face(other, face);
            }
            return this.face(direction, face);
        }

        public Builder face(Direction direction, Direction ... others) {
            for (Direction other : others) {
                this.face(other, FluidFace.NORMAL);
            }
            return this.face(direction, FluidFace.NORMAL);
        }

        public FluidCuboid build() {
            return new FluidCuboid(this.from, this.to, this.faces.isEmpty() ? DEFAULT_FACES : this.faces);
        }
    }
}

