/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.EmptyFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;

public abstract class AbstractFluidContainerTransferProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, TransferJson> allTransfers = new HashMap<ResourceLocation, TransferJson>();
    private final String modId;

    public AbstractFluidContainerTransferProvider(PackOutput packOutput, String modId) {
        super(packOutput, PackOutput.Target.DATA_PACK, "mantle/fluid_transfer", FluidContainerTransferManager.GSON);
        this.modId = modId;
    }

    protected abstract void addTransfers();

    protected void addTransfer(ResourceLocation id, IFluidContainerTransfer transfer, ICondition ... conditions) {
        TransferJson previous = this.allTransfers.putIfAbsent(id, new TransferJson(transfer, conditions));
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate fluid container transfer " + id);
        }
    }

    protected void addTransfer(String name, IFluidContainerTransfer transfer, ICondition ... conditions) {
        this.addTransfer(new ResourceLocation(this.modId, name), transfer, conditions);
    }

    protected void addFillEmpty(String prefix, ItemLike item, ItemLike container, FluidOutput fill, FluidIngredient drain, boolean nbt, ICondition ... conditions) {
        if (nbt) {
            this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyFluidWithNBTTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), ItemOutput.fromItem(container), fill), conditions);
            this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidWithNBTTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{container}), ItemOutput.fromItem(item), drain), conditions);
        } else {
            this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), ItemOutput.fromItem(container), fill), conditions);
            this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{container}), ItemOutput.fromItem(item), drain), conditions);
        }
    }

    protected void addFillEmpty(String prefix, ItemLike item, ItemLike container, Fluid fluid, TagKey<Fluid> tag, int amount, boolean nbt, ICondition ... conditions) {
        this.addFillEmpty(prefix, item, container, FluidOutput.fromFluid(fluid, amount), FluidIngredient.of(tag, amount), nbt, conditions);
    }

    protected void addFillEmpty(String prefix, ItemLike item, ItemLike container, FluidObject<?> fluid, int amount, boolean nbt, ICondition ... conditions) {
        this.addFillEmpty(prefix, item, container, fluid.result(amount), fluid.ingredient(amount), nbt, conditions);
    }

    @Deprecated(forRemoval=true)
    protected void addFillEmpty(String prefix, ItemLike item, ItemLike container, Fluid fluid, TagKey<Fluid> tag, int amount, ICondition ... conditions) {
        this.addFillEmpty(prefix, item, container, fluid, tag, amount, false, conditions);
    }

    @Deprecated(forRemoval=true)
    protected void addFillEmptyNBT(String prefix, ItemLike item, ItemLike container, Fluid fluid, TagKey<Fluid> tag, int amount, ICondition ... conditions) {
        this.addFillEmpty(prefix, item, container, fluid, tag, amount, true, conditions);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTransfers();
        return AbstractFluidContainerTransferProvider.allOf(this.allTransfers.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((TransferJson)entry.getValue()).toJson())));
    }

    private record TransferJson(IFluidContainerTransfer transfer, ICondition[] conditions) {
        public JsonElement toJson() {
            JsonElement element = FluidContainerTransferManager.GSON.toJsonTree((Object)this.transfer, IFluidContainerTransfer.class);
            assert (element.isJsonObject());
            if (this.conditions.length != 0) {
                JsonArray array = new JsonArray();
                for (ICondition condition : this.conditions) {
                    array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                element.getAsJsonObject().add("conditions", (JsonElement)array);
            }
            return element;
        }
    }
}

