/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.inventory.container.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerExtended
extends AbstractContainerMenu {
    @Nullable
    protected ServerPlayer player;

    protected ContainerExtended(MenuType<?> type, int id, Inventory inv) {
        super(type, id);
        Player player = inv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2;
            this.player = player2 = (ServerPlayer)player;
        }
    }

    public void m_150416_(final ContainerSynchronizer delegate) {
        super.m_150416_(new ContainerSynchronizer(){

            public void m_142589_(AbstractContainerMenu container, NonNullList<ItemStack> stacks, ItemStack carried, int[] data) {
                delegate.m_142589_(container, stacks, carried, data);
                if (ContainerExtended.this.player != null) {
                    for (int i = 0; i < stacks.size(); ++i) {
                        ItemStack stack = (ItemStack)stacks.get(i);
                        if (stack.m_41613_() <= 127) continue;
                        ContainerExtended.this.sendLargeStack(stack, i, ContainerExtended.this.player);
                    }
                }
            }

            public void m_142074_(AbstractContainerMenu container, int slot, ItemStack stack) {
                delegate.m_142074_(container, slot, stack);
                if (stack.m_41613_() > 127) {
                    ContainerExtended.this.sendLargeStack(stack, slot, ContainerExtended.this.player);
                }
            }

            public void m_142529_(AbstractContainerMenu container, ItemStack stack) {
                delegate.m_142529_(container, stack);
            }

            public void m_142145_(AbstractContainerMenu container, int slot, int data) {
                delegate.m_142145_(container, slot, data);
            }
        });
    }

    public void sendLargeStack(ItemStack stack, int slot, ServerPlayer player) {
    }

    public void m_150399_(int slot, int dragType, ClickType clickType, Player player) {
        Slot actualSlot;
        if (slot >= 0 && slot < this.f_38839_.size() && (actualSlot = this.m_38853_(slot)) instanceof SlotHandleClicks) {
            ((SlotHandleClicks)actualSlot).slotClick(this, player, dragType, clickType);
            return;
        }
        super.m_150399_(slot, dragType, clickType, player);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slotIndex) {
        ItemStack transferredStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            transferredStack = stack.m_41777_();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return transferredStack;
    }

    public boolean m_38903_(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41753_()) {
            while (stack.m_41613_() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                ItemStack slotStack = slot.m_7993_();
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) {
                    int maxStackSize;
                    int totalStackSize = slotStack.m_41613_() + stack.m_41613_();
                    if (totalStackSize <= (maxStackSize = Math.min(stack.m_41741_(), slot.m_6641_()))) {
                        stack.m_41764_(0);
                        slotStack.m_41764_(totalStackSize);
                        slot.m_6654_();
                        merged = true;
                    } else if (slotStack.m_41613_() < maxStackSize) {
                        stack.m_41774_(maxStackSize - slotStack.m_41613_());
                        slotStack.m_41764_(maxStackSize);
                        slot.m_6654_();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.m_41613_() > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.m_41613_() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                if (!slot.m_6657_() && slot.m_5857_(stack)) {
                    int maxStackSize = Math.min(stack.m_41741_(), slot.m_6641_());
                    if (stack.m_41613_() <= maxStackSize) {
                        slot.m_5852_(stack.m_41777_());
                        slot.m_6654_();
                        stack.m_41764_(0);
                    } else {
                        slot.m_5852_(stack.m_41620_(maxStackSize));
                        slot.m_6654_();
                    }
                    merged = true;
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean m_6875_(@Nonnull Player var1) {
        return true;
    }

    public void handleOutputPacket(PacketCustom packet) {
    }

    public void handleInputPacket(PacketCustom packet) {
    }

    public void handleGuiChange(int ID, int value) {
    }
}

