/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.lib;

import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public final class ModMobSoulTypes {
    private static final boolean DEBUG = false;
    private static final Set<ResourceLocation> FISH_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft:cod"), new ResourceLocation("minecraft:salmon"), new ResourceLocation("minecraft:tropical_fish"), new ResourceLocation("minecraft:pufferfish")});
    private static final Set<ResourceLocation> SLIME_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft:slime"), new ResourceLocation("tconstruct:earth_slime")});
    private static final Set<ResourceLocation> ZOMBIE_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft:zombie"), new ResourceLocation("minecraft:zombie_villager")});
    private static final Set<ResourceLocation> SPIDER_IDS = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft:spider"), new ResourceLocation("minecraft:cave_spider")});
    public static final MobSoulType PIG = new MobSoulType(new ResourceLocation("mysticalagriculture", "pig"), new ResourceLocation("minecraft:pig"), 8.0, 15771042);
    public static final MobSoulType CHICKEN = new MobSoulType(new ResourceLocation("mysticalagriculture", "chicken"), new ResourceLocation("minecraft:chicken"), 8.0, 0xA1A1A1);
    public static final MobSoulType COW = new MobSoulType(new ResourceLocation("mysticalagriculture", "cow"), new ResourceLocation("minecraft:cow"), 8.0, 4470310);
    public static final MobSoulType SHEEP = new MobSoulType(new ResourceLocation("mysticalagriculture", "sheep"), new ResourceLocation("minecraft:sheep"), 8.0, 0xE7E7E7);
    public static final MobSoulType SQUID = new MobSoulType(new ResourceLocation("mysticalagriculture", "squid"), new ResourceLocation("minecraft:squid"), 6.0, 2243405);
    public static final MobSoulType FISH = new MobSoulType(new ResourceLocation("mysticalagriculture", "fish"), FISH_IDS, "fish", 6.0, 12691306);
    public static final MobSoulType SLIME = new MobSoulType(new ResourceLocation("mysticalagriculture", "slime"), SLIME_IDS, "slime", 12.0, 5349438);
    public static final MobSoulType TURTLE = new MobSoulType(new ResourceLocation("mysticalagriculture", "turtle"), new ResourceLocation("minecraft:turtle"), 6.0, 44975);
    public static final MobSoulType ZOMBIE = new MobSoulType(new ResourceLocation("mysticalagriculture", "zombie"), ZOMBIE_IDS, "zombie", 10.0, 7969893);
    public static final MobSoulType SKELETON = new MobSoulType(new ResourceLocation("mysticalagriculture", "skeleton"), new ResourceLocation("minecraft:skeleton"), 10.0, 0xC1C1C1);
    public static final MobSoulType CREEPER = new MobSoulType(new ResourceLocation("mysticalagriculture", "creeper"), new ResourceLocation("minecraft:creeper"), 10.0, 894731);
    public static final MobSoulType SPIDER = new MobSoulType(new ResourceLocation("mysticalagriculture", "spider"), SPIDER_IDS, "spider", 10.0, 3419431);
    public static final MobSoulType RABBIT = new MobSoulType(new ResourceLocation("mysticalagriculture", "rabbit"), new ResourceLocation("minecraft:rabbit"), 6.0, 10051392);
    public static final MobSoulType BLAZE = new MobSoulType(new ResourceLocation("mysticalagriculture", "blaze"), new ResourceLocation("minecraft:blaze"), 10.0, 16167425);
    public static final MobSoulType GHAST = new MobSoulType(new ResourceLocation("mysticalagriculture", "ghast"), new ResourceLocation("minecraft:ghast"), 4.0, 0xF9F9F9);
    public static final MobSoulType ENDERMAN = new MobSoulType(new ResourceLocation("mysticalagriculture", "enderman"), new ResourceLocation("minecraft:enderman"), 8.0, 0x161616);
    public static final MobSoulType WITHER = new MobSoulType(new ResourceLocation("mysticalagriculture", "wither_skeleton"), new ResourceLocation("minecraft:wither_skeleton"), 8.0, 0x141414);
    public static final MobSoulType BLIZZ = new MobSoulType(new ResourceLocation("mysticalagriculture", "blizz"), new ResourceLocation("thermal:blizz"), 6.0, 8115455);
    public static final MobSoulType BLITZ = new MobSoulType(new ResourceLocation("mysticalagriculture", "blitz"), new ResourceLocation("thermal:blitz"), 6.0, 0xECFEFC);
    public static final MobSoulType BASALZ = new MobSoulType(new ResourceLocation("mysticalagriculture", "basalz"), new ResourceLocation("thermal:basalz"), 6.0, 3553344);

    public static void onRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        registry.register(PIG);
        registry.register(CHICKEN);
        registry.register(COW);
        registry.register(SHEEP);
        registry.register(SQUID);
        registry.register(FISH);
        registry.register(SLIME);
        registry.register(TURTLE);
        registry.register(ZOMBIE);
        registry.register(SKELETON);
        registry.register(CREEPER);
        registry.register(SPIDER);
        registry.register(RABBIT);
        registry.register(BLAZE);
        registry.register(GHAST);
        registry.register(ENDERMAN);
        registry.register(WITHER);
        registry.register(ModMobSoulTypes.withRequiredMods(BLIZZ, "thermal"));
        registry.register(ModMobSoulTypes.withRequiredMods(BLITZ, "thermal"));
        registry.register(ModMobSoulTypes.withRequiredMods(BASALZ, "thermal"));
    }

    private static MobSoulType withRequiredMods(MobSoulType type, String ... mods) {
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return type.setEnabled(enabled);
    }
}

