/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.blockentity;

import com.mikitellurium.turtlecharginstation.block.ThunderchargeDynamoBlock;
import com.mikitellurium.turtlecharginstation.registry.ModBlockEntities;
import com.mikitellurium.turtlecharginstation.registry.ModTags;
import com.mikitellurium.turtlecharginstation.util.ConductiveBlockContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class ThunderchargeDynamoBlockEntity
extends BlockEntity {
    private int charge = 0;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    public static ForgeConfigSpec.IntValue RECHARGE_AMOUNT;

    public ThunderchargeDynamoBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.THUNDERCHARGE_DYNAMO.get(), blockPos, blockState);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level.f_46443_) {
            return;
        }
        if (this.charge > 0) {
            HashSet chargedBlockEntities = new HashSet();
            for (Direction direction : Direction.values()) {
                Map<BlockEntity, Direction> blockEntities;
                if (direction == Direction.UP || (blockEntities = this.findConnectedBlockEntities(level, blockPos, direction, new HashSet<BlockPos>())).isEmpty()) continue;
                blockEntities.entrySet().stream().filter(entry -> !chargedBlockEntities.contains(entry.getKey())).forEach(entry -> {
                    BlockEntity be = (BlockEntity)entry.getKey();
                    if (be.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                        be.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> energyStorage.receiveEnergy(((Integer)TRANSFER_RATE.get()).intValue(), false));
                        chargedBlockEntities.add(be);
                    }
                });
            }
            --this.charge;
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ThunderchargeDynamoBlock.POWERED, (Comparable)Boolean.valueOf(this.charge > 0)));
        ThunderchargeDynamoBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
    }

    private Map<BlockEntity, Direction> findConnectedBlockEntities(Level level, BlockPos startPos, Direction startDirection, Set<BlockPos> checkedPosSet) {
        HashMap<BlockEntity, Direction> blockEntities = new HashMap<BlockEntity, Direction>();
        BlockPos relative = startPos.m_121945_(startDirection);
        if (checkedPosSet.contains(relative)) {
            return blockEntities;
        }
        BlockState blockState = level.m_8055_(relative);
        ConductiveBlockContext context = new ConductiveBlockContext(blockState);
        BlockEntity blockEntity = level.m_7702_(relative);
        if (blockEntity != null) {
            blockEntities.put(blockEntity, startDirection);
        } else if (blockState.m_204336_(ModTags.DYNAMO_CONDUCTIVE_BLOCKS)) {
            if (!context.canConductTo(level.m_8055_(startPos), startDirection)) {
                return blockEntities;
            }
            checkedPosSet.add(relative);
            for (Direction direction : context.getDirections()) {
                if (direction == startDirection.m_122424_()) continue;
                blockEntities.putAll(this.findConnectedBlockEntities(level, relative, direction, checkedPosSet));
            }
        }
        return blockEntities;
    }

    public int getCharge() {
        return this.charge;
    }

    public void recharge() {
        this.charge = Math.min(this.getCharge() + (Integer)RECHARGE_AMOUNT.get(), Integer.MAX_VALUE);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.charge = nbt.m_128451_("charge");
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("charge", this.charge);
        super.m_183515_(nbt);
    }
}

