/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.config;

import com.mikitellurium.turtlecharginstation.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlecharginstation.blockentity.TurtleChargingStationBlockEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfig {
    public static void registerConfig() {
        ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
        ModConfig.setupConfig(CONFIG_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG_BUILDER.build());
    }

    public static void setupConfig(ForgeConfigSpec.Builder CONFIG_BUILDER) {
        CONFIG_BUILDER.comment("Turtle Charging Station Configuration").push("turtlechargingstation");
        TurtleChargingStationBlockEntity.CAPACITY = CONFIG_BUILDER.comment("The maximum amount of FE the charging station can hold").defineInRange("chargingStationMaxCapacity", 64000, 0, Integer.MAX_VALUE);
        TurtleChargingStationBlockEntity.CONVERSION_RATE = CONFIG_BUILDER.comment("The amount of FE required to increase the turtle fuel level by 1").defineInRange("chargingStationConversionRate", 256, 0, Integer.MAX_VALUE);
        ThunderchargeDynamoBlockEntity.RECHARGE_AMOUNT = CONFIG_BUILDER.comment(new String[]{"The amount of time (in ticks) that is added to the thundercharge dynamo charge.", "1 minute = 1200 in-game ticks"}).defineInRange("dynamoRechargeAmount", 1200, 0, Integer.MAX_VALUE);
        ThunderchargeDynamoBlockEntity.TRANSFER_RATE = CONFIG_BUILDER.comment("The amount of FE/tick generated by the thundercharge dynamo").defineInRange("dynamoTransferRate", 1024, 0, Integer.MAX_VALUE);
        CONFIG_BUILDER.pop();
    }
}

