/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.event;

import com.mikitellurium.turtlecharginstation.TurtleChargingStationMod;
import com.mikitellurium.turtlecharginstation.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlecharginstation.registry.ModTags;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="turtlechargingstation", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final Field DATA_IS_POWERED = ObfuscationReflectionHelper.findField(Creeper.class, (String)"f_32274_");

    @SubscribeEvent
    public static void onLightningStrike(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(ModTags.DYNAMO_ACTIVATORS)) {
            BlockEntity maybeDynamo = ModEvents.getBlockEntityBelowStrike(entity.m_9236_(), entity.m_20097_());
            if (maybeDynamo == null) {
                return;
            }
            if (maybeDynamo instanceof ThunderchargeDynamoBlockEntity) {
                LightningBolt lightningBolt;
                ThunderchargeDynamoBlockEntity dynamo = (ThunderchargeDynamoBlockEntity)maybeDynamo;
                dynamo.recharge();
                if (entity instanceof LightningBolt && (lightningBolt = (LightningBolt)entity).m_147158_() == null) {
                    ModEvents.maybeDoSpawnCreeper((ServerLevel)entity.m_9236_(), dynamo.m_58899_());
                }
            }
        }
    }

    private static BlockEntity getBlockEntityBelowStrike(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        return blockEntity != null ? blockEntity : level.m_7702_(blockPos.m_7495_());
    }

    private static void maybeDoSpawnCreeper(ServerLevel level, BlockPos pos) {
        if (level.f_46441_.m_188503_(1023) == 0) {
            Optional<BlockPos> blockPos = ModEvents.getPossibleSpawnPos((Level)level, pos);
            blockPos.ifPresent(p -> {
                Creeper creeper = (Creeper)EntityType.f_20558_.m_262496_(level, p, MobSpawnType.EVENT);
                if (creeper != null) {
                    try {
                        EntityDataAccessor creeperIsPowered = (EntityDataAccessor)DATA_IS_POWERED.get(creeper);
                        creeper.m_20088_().m_135381_(creeperIsPowered, (Object)true);
                    }
                    catch (IllegalAccessException e) {
                        TurtleChargingStationMod.LOGGER.error("Failed to charge creeper");
                    }
                }
            });
        }
    }

    private static Optional<BlockPos> getPossibleSpawnPos(Level level, BlockPos blockPos) {
        BlockPos startPos = blockPos.m_7918_(1, 2, 1);
        BlockPos downPos = blockPos.m_7918_(-1, -10, -1);
        List<BlockPos> list = BlockPos.m_121990_((BlockPos)startPos, (BlockPos)downPos).filter(pos -> level.m_45527_(pos) && NaturalSpawner.canSpawnAtBody((SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (LevelReader)level, (BlockPos)pos, (EntityType)EntityType.f_20558_)).map(BlockPos::m_7949_).toList();
        return Util.m_214676_(list, (RandomSource)level.f_46441_);
    }
}

