/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.common.data.BlockLootTablesProvider;
import de.srendi.advancedperipherals.common.data.BlockStatesAndModelsProvider;
import de.srendi.advancedperipherals.common.data.BlockTagsProvider;
import de.srendi.advancedperipherals.common.data.EnUsLanguageProvider;
import de.srendi.advancedperipherals.common.data.PocketUpgradesProvider;
import de.srendi.advancedperipherals.common.data.PoiTypeProvider;
import de.srendi.advancedperipherals.common.data.RecipesProvider;
import de.srendi.advancedperipherals.common.data.TurtleUpgradesProvider;
import de.srendi.advancedperipherals.common.setup.Registration;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="advancedperipherals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void genData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> completablefuture = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagsProvider(packOutput, completablefuture, existingFileHelper, Registration.BLOCKS));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockLootTablesProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new TurtleUpgradesProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new PocketUpgradesProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new PoiTypeProvider(packOutput, completablefuture, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockStatesAndModelsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLanguageProvider(packOutput));
    }
}

