/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFilter {
    private Item item = Items.f_41852_;
    private TagKey<Item> tag = null;
    private CompoundTag nbt = null;
    private int count = 64;
    private String fingerprint = "";
    public int fromSlot = -1;
    public int toSlot = -1;

    private ItemFilter() {
    }

    public static Pair<ItemFilter, String> parse(Map<?, ?> item) {
        ItemFilter itemFilter = ItemFilter.empty();
        if (item.isEmpty()) {
            return Pair.of(itemFilter, null);
        }
        if (item.containsKey("name")) {
            try {
                String name = TableHelper.getStringField(item, (String)"name");
                if (name.startsWith("#")) {
                    itemFilter.tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name.substring(1)));
                } else {
                    itemFilter.item = (Item)ItemUtil.getRegistryEntry(name, ForgeRegistries.ITEMS);
                    if (itemFilter.item == null) {
                        return Pair.of(null, "ITEM_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_ITEM");
            }
        }
        if (item.containsKey("nbt")) {
            try {
                itemFilter.nbt = NBTUtil.fromText(TableHelper.getStringField(item, (String)"nbt"));
            }
            catch (LuaException luaException) {
                try {
                    itemFilter.nbt = NBTUtil.fromText(TableHelper.getTableField(item, (String)"nbt").toString());
                }
                catch (LuaException e) {
                    return Pair.of(null, "NO_VALID_NBT");
                }
            }
        }
        if (item.containsKey("fingerprint")) {
            try {
                itemFilter.fingerprint = TableHelper.getStringField(item, (String)"fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey("fromSlot")) {
            try {
                itemFilter.fromSlot = TableHelper.getIntField(item, (String)"fromSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FROMSLOT");
            }
        }
        if (item.containsKey("toSlot")) {
            try {
                itemFilter.toSlot = TableHelper.getIntField(item, (String)"toSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_TOSLOT");
            }
        }
        if (item.containsKey("count")) {
            try {
                itemFilter.count = TableHelper.getIntField(item, (String)"count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed item filter: " + itemFilter);
        return Pair.of(itemFilter, null);
    }

    public static ItemFilter fromStack(ItemStack stack) {
        ItemFilter filter = ItemFilter.empty();
        filter.item = stack.m_41720_();
        filter.nbt = stack.m_41782_() ? stack.m_41783_() : null;
        return filter;
    }

    public static ItemFilter empty() {
        return new ItemFilter();
    }

    public boolean isEmpty() {
        return this.fingerprint.isEmpty() && this.item == Items.f_41852_ && this.tag == null && this.nbt == null;
    }

    public ItemStack toItemStack() {
        ItemStack result = new ItemStack((ItemLike)this.item, this.count);
        result.m_41751_(this.nbt != null ? this.nbt.m_6426_() : null);
        return result;
    }

    public boolean test(ItemStack stack) {
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = ItemUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.item != Items.f_41852_ && !stack.m_150930_(this.item)) {
            return false;
        }
        if (this.tag != null && !stack.m_204117_(this.tag)) {
            return false;
        }
        return this.nbt == null || stack.m_41784_().equals((Object)this.nbt);
    }

    public int getCount() {
        return this.count;
    }

    public Item getItem() {
        return this.item;
    }

    public int getFromSlot() {
        return this.fromSlot;
    }

    public int getToSlot() {
        return this.toSlot;
    }

    public Tag getNbt() {
        return this.nbt;
    }

    public String toString() {
        return "ItemFilter{item=" + ItemUtil.getRegistryKey(this.item) + ", tag=" + this.tag + ", nbt=" + this.nbt + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "', fromSlot=" + this.fromSlot + ", toSlot=" + this.toSlot + "}";
    }
}

