/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTrade
implements VillagerTrades.ItemListing {
    private final Type type;
    private final int emeraldAmount;
    private final int itemAmount;
    private final int maxUses;
    private final int xp;
    private final ItemLike item;
    private final ItemStack itemStack;

    private VillagerTrade(@NotNull Type type, int emeraldAmount, int itemAmount, int maxUses, int xp, ItemLike item, ItemStack itemStack) {
        this.type = type;
        this.emeraldAmount = emeraldAmount;
        this.itemAmount = itemAmount;
        this.maxUses = maxUses;
        this.xp = xp;
        this.item = item;
        this.itemStack = itemStack;
    }

    @Nullable
    public MerchantOffer m_213663_(@NotNull Entity trader, @NotNull RandomSource rand) {
        if (this.type == Type.EMERALD_FOR_ITEM) {
            if (this.itemStack != null) {
                return new MerchantOffer(this.itemStack, new ItemStack((ItemLike)Items.f_42616_, this.emeraldAmount), this.maxUses, this.xp, 1.0f);
            }
            if (this.item != null) {
                return new MerchantOffer(new ItemStack(this.item, this.itemAmount), new ItemStack((ItemLike)Items.f_42616_, this.emeraldAmount), this.maxUses, this.xp, 1.0f);
            }
        }
        if (this.type == Type.ITEM_FOR_EMERALD) {
            if (this.itemStack != null) {
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldAmount), this.itemStack, this.maxUses, this.xp, 1.0f);
            }
            if (this.item != null) {
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldAmount), new ItemStack(this.item, this.itemAmount), this.maxUses, this.xp, 1.0f);
            }
        }
        return null;
    }

    public static enum Type {
        ITEM_FOR_EMERALD,
        EMERALD_FOR_ITEM;

    }

    public static class TradeBuilder {
        private VillagerTradesEvent villagerEvent;
        private WandererTradesEvent wandererEvent;
        private final int professionLevel;
        private final Type type;
        private final int emeraldAmount;
        private int itemAmount = 1;
        private int maxUses = 10;
        private int xp = 2;
        private final ItemLike item;
        private final ItemStack itemStack;

        private TradeBuilder(VillagerTradesEvent event, ItemLike item, Type type, int emeraldAmount, int professionLevel) {
            this.villagerEvent = event;
            this.item = item;
            this.itemStack = null;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        private TradeBuilder(VillagerTradesEvent event, ItemStack stack, Type type, int emeraldAmount, int professionLevel) {
            this.villagerEvent = event;
            this.itemStack = stack;
            this.item = null;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        private TradeBuilder(WandererTradesEvent event, ItemLike item, Type type, int emeraldAmount, int professionLevel) {
            this.wandererEvent = event;
            this.item = item;
            this.itemStack = null;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        private TradeBuilder(WandererTradesEvent event, ItemStack stack, Type type, int emeraldAmount, int professionLevel) {
            this.wandererEvent = event;
            this.itemStack = stack;
            this.item = null;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        public static TradeBuilder createTrade(VillagerTradesEvent event, ItemLike itemLike, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, itemLike, type, emeraldAmount, professionLevel);
        }

        public static TradeBuilder createTrade(VillagerTradesEvent event, ItemStack itemStack, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, itemStack, type, emeraldAmount, professionLevel);
        }

        public static TradeBuilder createTrade(WandererTradesEvent event, ItemLike itemLike, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, itemLike, type, emeraldAmount, professionLevel);
        }

        public static TradeBuilder createTrade(WandererTradesEvent event, ItemStack itemStack, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, itemStack, type, emeraldAmount, professionLevel);
        }

        public TradeBuilder setItemAmount(int itemAmount) {
            this.itemAmount = itemAmount;
            return this;
        }

        public TradeBuilder setMaxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public TradeBuilder setXp(int xp) {
            this.xp = xp;
            return this;
        }

        public void build() {
            VillagerTrade trade = new VillagerTrade(this.type, this.emeraldAmount, this.itemAmount, this.maxUses, this.xp, this.item, this.itemStack);
            if (this.wandererEvent != null) {
                if (this.professionLevel == 1) {
                    this.wandererEvent.getGenericTrades().add(trade);
                }
                if (this.professionLevel == 2) {
                    this.wandererEvent.getRareTrades().add(trade);
                }
                return;
            }
            ((List)this.villagerEvent.getTrades().get(this.professionLevel)).add(trade);
        }
    }
}

