/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public abstract class GenericDataProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final Gson gson;

    public GenericDataProvider(PackOutput output, PackOutput.Target type, String folder, Gson gson) {
        this(output.m_245269_(type, folder), gson);
    }

    public GenericDataProvider(DataGenerator generator, PackOutput.Target type, String folder, Gson gson) {
        this(generator.getPackOutput(), type, folder, gson);
    }

    public GenericDataProvider(PackOutput output, PackOutput.Target type, String folder) {
        this(output, type, folder, JsonHelper.DEFAULT_GSON);
    }

    public GenericDataProvider(DataGenerator generator, PackOutput.Target type, String folder) {
        this(generator, type, folder, JsonHelper.DEFAULT_GSON);
    }

    protected CompletableFuture<?> saveJson(CachedOutput output, ResourceLocation location, Object object, @Nullable Comparator<String> keyComparator) {
        return GenericDataProvider.saveStable(output, this.gson.toJsonTree(object), this.pathProvider.m_245731_(location), keyComparator).exceptionally(e -> {
            Mantle.logger.error("Couldn't create data for {}", (Object)location, e);
            return null;
        });
    }

    protected CompletableFuture<?> saveJson(CachedOutput output, ResourceLocation location, Object object) {
        return this.saveJson(output, location, object, DataProvider.f_236068_);
    }

    protected <T> CompletableFuture<?> saveJson(CachedOutput output, ResourceLocation location, Codec<T> codec, T object) {
        return this.saveJson(output, location, codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0)));
    }

    public static CompletableFuture<?> allOf(Stream<CompletableFuture<?>> stream) {
        return CompletableFuture.allOf((CompletableFuture[])stream.toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<?> allOf(Collection<CompletableFuture<?>> tasks) {
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    static CompletableFuture<?> saveStable(CachedOutput cache, JsonElement pJson, Path pPath, @Nullable Comparator<String> keyComparator) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                HashingOutputStream hashingOutput = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteOutput);
                try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutput, StandardCharsets.UTF_8));){
                    writer.setSerializeNulls(false);
                    writer.setIndent("  ");
                    GsonHelper.m_216207_((JsonWriter)writer, (JsonElement)pJson, (Comparator)keyComparator);
                }
                cache.m_213871_(pPath, byteOutput.toByteArray(), hashingOutput.hash());
            }
            catch (IOException exception) {
                throw new CompletionException(exception);
            }
        }, Util.m_183991_());
    }

    public GenericDataProvider(PackOutput.PathProvider pathProvider, Gson gson) {
        this.pathProvider = pathProvider;
        this.gson = gson;
    }
}

