/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.object.ItemObject;

public class BuildingBlockObject
extends ItemObject<Block> {
    private final Supplier<? extends SlabBlock> slab;
    private final Supplier<? extends StairBlock> stairs;

    public BuildingBlockObject(Block block, Block slab, Block stairs) {
        super(BuiltInRegistries.f_256975_, block);
        this.slab = RegistrationHelper.getCastedHolder(BuiltInRegistries.f_256975_, slab);
        this.stairs = RegistrationHelper.getCastedHolder(BuiltInRegistries.f_256975_, stairs);
    }

    public BuildingBlockObject(ItemObject<? extends Block> block, Supplier<? extends SlabBlock> slab, Supplier<? extends StairBlock> stairs) {
        super(block);
        this.slab = slab;
        this.stairs = stairs;
    }

    protected BuildingBlockObject(BuildingBlockObject object) {
        super(object);
        this.slab = object.slab;
        this.stairs = object.stairs;
    }

    public SlabBlock getSlab() {
        return Objects.requireNonNull(this.slab.get(), "Building Block Object missing slab");
    }

    public StairBlock getStairs() {
        return Objects.requireNonNull(this.stairs.get(), "Building Block Object missing stairs");
    }

    public List<Block> values() {
        return Arrays.asList((Block)this.get(), this.getSlab(), this.getStairs());
    }

    public void forEach(Consumer<ItemLike> consumer) {
        consumer.accept((ItemLike)this.get());
        consumer.accept((ItemLike)this.getSlab());
        consumer.accept((ItemLike)this.getStairs());
    }
}

