/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.IdAwareObject;

public class FluidObject<F extends Fluid>
implements Supplier<F>,
ItemLike,
IdAwareObject {
    @Nonnull
    protected final ResourceLocation id;
    @Nullable
    protected final TagKey<Fluid> commonTag;
    private final Supplier<? extends FluidType> type;
    private final Supplier<? extends F> still;

    public FluidObject(ResourceLocation id, @Nullable String tagName, Supplier<? extends FluidType> type, Supplier<? extends F> still) {
        this.id = id;
        this.commonTag = tagName == null ? null : FluidTags.create((ResourceLocation)Mantle.commonResource(tagName));
        this.type = type;
        this.still = still;
    }

    public FluidType getType() {
        return this.type.get();
    }

    @Override
    public F get() {
        return (F)Objects.requireNonNull((Fluid)this.still.get(), "Fluid object missing still fluid");
    }

    @Nullable
    public Item getBucket() {
        Item bucket = ((Fluid)this.still.get()).m_6859_();
        if (bucket == Items.f_41852_) {
            return null;
        }
        return bucket;
    }

    public Item m_5456_() {
        return ((Fluid)this.still.get()).m_6859_();
    }

    public FluidIngredient ingredient(int amount) {
        if (this.commonTag != null) {
            return FluidIngredient.of(this.commonTag, amount);
        }
        return FluidIngredient.of(this.get(), amount);
    }

    public FluidOutput result(int amount) {
        if (this.commonTag != null) {
            return FluidOutput.fromTag(this.commonTag, amount);
        }
        return FluidOutput.fromFluid(this.get(), amount);
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Nullable
    public TagKey<Fluid> getCommonTag() {
        return this.commonTag;
    }
}

