/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.hud.ElementRegistry;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @SubscribeEvent
    public static void onCommonReload(ModConfigEvent ev) {
        if (ev.getConfig().getSpec().equals(COMMON_SPEC)) {
            BloodMagic.handleConfigValues(BloodMagicAPI.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onClientReload(ModConfigEvent ev) {
        if (ev.getConfig().getSpec().equals(CLIENT_SPEC)) {
            System.out.println("Reloading...?");
            ElementRegistry.readConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wellOfSuffering;
        public final ForgeConfigSpec.IntValue sacrificialDaggerConversion;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sacrificialValues;
        public final ForgeConfigSpec.BooleanValue makeDungeonRitualCreativeOnly;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Stops the listed entities from being used in the Well of Suffering.", "Use the registry name of the entity. Vanilla entities do not require the modid."}).push("Blacklist");
            this.wellOfSuffering = builder.defineList("wellOfSuffering", (List)ImmutableList.of(), obj -> true);
            builder.pop();
            builder.comment("Amount of LP the Sacrificial Dagger should provide for each damage dealt.").push("Config Values");
            this.sacrificialDaggerConversion = builder.defineInRange("sacrificialDaggerConversion", 100, 0, 10000);
            builder.comment(new String[]{"Declares the amount of LP gained per HP sacrificed for the given entity.", "Setting the value to 0 will blacklist it.", "Use the registry name of the entity followed by a ';' and then the value you want.", "Vanilla entities do not require the modid."});
            this.sacrificialValues = builder.defineList("sacrificialValues", (List)ImmutableList.of((Object)"villager;100", (Object)"slime;15", (Object)"enderman;10", (Object)"cow;100", (Object)"chicken;100", (Object)"horse;100", (Object)"sheep;100", (Object)"wolf;100", (Object)"ocelot;100", (Object)"pig;100", (Object)"rabbit;100"), obj -> true);
            builder.comment(new String[]{"State that the dungeon spawning ritual can only be activated when using a Creative Activation Crystal.", "Used on servers for if you do not trust your players to not destroy other people's bases."});
            this.makeDungeonRitualCreativeOnly = builder.define("makeDungeonRitualCreativeOnly", false);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue alwaysRenderRoutingLines;
        public final ForgeConfigSpec.BooleanValue sigilHoldingSkipsEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Always render the beams between routing nodes.", "If disabled, the beams will only render while the Node Router is held."}).push("client");
            this.alwaysRenderRoutingLines = builder.define("alwaysRenderRoutingLines", false);
            builder.comment(new String[]{"When cycling through slots, the Sigil of Holding will skip over empty slots and move to the next occupied one.", "If disabled, it will behave identically to the default hotbar."});
            this.sigilHoldingSkipsEmptySlots = builder.define("sigilHoldingSkipsEmptySlots", false);
            builder.pop();
        }
    }
}

