/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;

public class PotionCycleRecipeBuilder
extends BloodMagicRecipeBuilder<PotionCycleRecipeBuilder> {
    private final List<Ingredient> input;
    private final int numCycles;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionCycleRecipeBuilder(List<Ingredient> input, int numCycles, int syphon, int ticks, int minimumTier) {
        super(PotionCycleRecipeBuilder.bmSerializer("flask_potioncycle"));
        this.input = input;
        this.numCycles = numCycles;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionCycleRecipeBuilder potionCycle(int numCycles, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionCycleRecipeBuilder(inputList, numCycles, syphon, ticks, minimumTier);
    }

    public PotionCycleRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionFillRecipeResult getResult(ResourceLocation id) {
        return new PotionFillRecipeResult(id);
    }

    public class PotionFillRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionFillRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (PotionCycleRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionCycleRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.addProperty("count", (Number)PotionCycleRecipeBuilder.this.numCycles);
            json.addProperty("syphon", (Number)PotionCycleRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionCycleRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionCycleRecipeBuilder.this.minimumTier);
        }
    }
}

