/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<BlockHitResult>
implements BlockAccessor {
    private final BlockState blockState;
    @Nullable
    private final Supplier<BlockEntity> blockEntity;
    private ItemStack fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, Suppliers.ofInstance((Object)builder.hit), builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    public static void handleRequest(FriendlyByteBuf buf, ServerPlayer player, Consumer<Runnable> executor, Consumer<CompoundTag> responseSender) {
        BlockAccessor accessor;
        try {
            accessor = BlockAccessorImpl.fromNetwork(buf, player);
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, null, null, null);
            return;
        }
        executor.accept(() -> {
            BlockPos pos = accessor.getPosition();
            ServerLevel world = player.m_284548_();
            if (pos.m_123331_((Vec3i)player.m_20183_()) > (double)Jade.MAX_DISTANCE_SQR || !world.m_46749_(pos)) {
                return;
            }
            BlockEntity tile = accessor.getBlockEntity();
            if (tile == null) {
                return;
            }
            List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.INSTANCE.getBlockNBTProviders(tile);
            if (providers.isEmpty()) {
                return;
            }
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<BlockAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null, null);
                }
            }
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            tag.m_128359_("id", CommonProxy.getId(tile.m_58903_()).toString());
            responseSender.accept(tag);
        });
    }

    public static BlockAccessor fromNetwork(FriendlyByteBuf buf, ServerPlayer player) {
        Builder builder = new Builder();
        builder.level(player.m_9236_());
        builder.player((Player)player);
        builder.showDetails(buf.readBoolean());
        builder.hit(buf.m_130283_());
        builder.blockState(Block.m_49803_((int)buf.m_130242_()));
        builder.fakeBlock(buf.m_130267_());
        if (builder.blockState.m_155947_()) {
            builder.blockEntity((Supplier)Suppliers.memoize(() -> builder.level.m_7702_(builder.hit.m_82425_())));
        }
        return builder.build();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showDetails());
        buf.m_130062_((BlockHitResult)this.getHitResult());
        buf.m_130130_(Block.m_49956_((BlockState)this.blockState));
        buf.m_130055_(this.fakeBlock);
    }

    @Override
    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity == null ? null : this.blockEntity.get();
    }

    @Override
    public BlockPos getPosition() {
        return ((BlockHitResult)this.getHitResult()).m_82425_();
    }

    @Override
    public Direction getSide() {
        return ((BlockHitResult)this.getHitResult()).m_82434_();
    }

    @Override
    public ItemStack getPickedResult() {
        return CommonProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (BlockHitResult)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.m_41619_();
    }

    @Override
    public ItemStack getFakeBlock() {
        return this.fakeBlock;
    }

    public void setFakeBlock(ItemStack fakeBlock) {
        this.fakeBlock = fakeBlock;
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        int x = data.m_128451_("x");
        int y = data.m_128451_("y");
        int z = data.m_128451_("z");
        BlockPos hitPos = this.getPosition();
        return x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_();
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private boolean showDetails;
        private BlockHitResult hit;
        private BlockState blockState = Blocks.f_50016_.m_49966_();
        private Supplier<BlockEntity> blockEntity;
        private ItemStack fakeBlock = ItemStack.f_41583_;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(BlockHitResult hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(Supplier<BlockEntity> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(ItemStack stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (BlockHitResult)accessor.getHitResult();
            this.blockEntity = accessor::getBlockEntity;
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }
}

