/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.renderer.block;

import com.enderio.base.common.blockentity.EnderSkullBlockEntity;
import com.enderio.base.common.init.EIOBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EnderSkullRenderer
implements BlockEntityRenderer<EnderSkullBlockEntity> {
    public static final RenderType RENDERTYPE = RenderType.m_110464_((ResourceLocation)new ResourceLocation("textures/entity/enderman/enderman.png"));
    EnderSkullModel skullmodelbase;
    public static ModelLayerLocation ENDER_SKULL = new ModelLayerLocation(new ResourceLocation("enderman_head"), "main");

    public EnderSkullRenderer(BlockEntityRendererProvider.Context context) {
        this.skullmodelbase = new EnderSkullModel(context.m_173585_().m_171103_(ENDER_SKULL));
    }

    public void render(EnderSkullBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float f = blockEntity.getAnimation(partialTick);
        BlockState blockstate = blockEntity.m_58900_();
        boolean flag = blockstate.m_60734_() instanceof WallSkullBlock;
        Direction direction = flag ? (Direction)blockstate.m_61143_((Property)WallSkullBlock.f_58097_) : null;
        int i = flag ? RotationSegment.m_245225_((Direction)direction.m_122424_()) : (Integer)blockstate.m_61143_((Property)SkullBlock.f_56314_);
        float f1 = RotationSegment.m_245107_((int)i);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 position = player.m_20182_();
        HitResult hitResult = player.m_19907_(10.0, 0.0f, false);
        this.skullmodelbase.active = false;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (player.m_9236_().m_7702_(blockHitResult.m_82425_()) == blockEntity) {
                blockEntity.setAnimation(30.0f);
                f = 30.0f;
            }
        }
        if (f > 0.0f) {
            this.skullmodelbase.active = true;
            f1 = (float)(Mth.m_14136_((double)(position.f_82481_ - (double)blockEntity.m_58899_().m_123343_() - 0.5), (double)(position.f_82479_ - (double)blockEntity.m_58899_().m_123341_() - 0.5)) * 180.0 / Math.PI + 90.0);
            f1 = (float)((double)f1 + player.m_217043_().m_188583_() * 2.0);
            int rotation = RotationSegment.m_246374_((float)f1);
            if (player.m_9236_().m_7702_(blockEntity.m_58899_()) == blockEntity && blockstate.m_60713_((Block)EIOBlocks.ENDERMAN_HEAD.get())) {
                player.m_9236_().m_7731_(blockEntity.m_58899_(), (BlockState)blockstate.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation)), 3);
            }
        }
        SkullBlockRenderer.m_173663_((Direction)direction, (float)f1, (float)f, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (SkullModelBase)this.skullmodelbase, (RenderType)RENDERTYPE);
    }

    public static class EnderSkullModel
    extends SkullModelBase {
        private final ModelPart head;
        private final ModelPart hat;
        private final ModelPart root;
        private boolean active = false;

        public EnderSkullModel(ModelPart root) {
            this.root = root;
            this.head = root.m_171324_("head");
            this.hat = root.m_171324_("hat");
        }

        public static MeshDefinition createHeadModel() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.f_171404_);
            partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
            return meshdefinition;
        }

        public static LayerDefinition createMobHeadLayer() {
            MeshDefinition meshdefinition = EnderSkullModel.createHeadModel();
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void m_6251_(float p_103811_, float p_103812_, float p_103813_) {
            this.head.f_104204_ = p_103812_ * ((float)Math.PI / 180);
            this.head.f_104203_ = p_103813_ * ((float)Math.PI / 180);
            this.hat.f_104204_ = this.head.f_104204_;
            this.hat.f_104203_ = this.head.f_104203_;
            this.head.f_104201_ = 0.0f;
            if (this.active) {
                this.head.f_104201_ = -5.0f;
            }
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.root.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

