/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.model.block;

import com.enderio.EnderIO;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PaintedBlockModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    @Nullable
    private Block referenceBlock = null;
    private Direction itemTextureRotation = Direction.NORTH;

    public static <T extends ModelBuilder<T>> PaintedBlockModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new PaintedBlockModelBuilder<T>(parent, existingFileHelper);
    }

    protected PaintedBlockModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(EnderIO.loc("painted_block"), parent, existingFileHelper);
    }

    public PaintedBlockModelBuilder<T> reference(Block referenceBlock) {
        this.referenceBlock = referenceBlock;
        return this;
    }

    public PaintedBlockModelBuilder<T> itemTextureRotation(Direction direction) {
        this.itemTextureRotation = direction;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        json.addProperty("reference", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)Objects.requireNonNull(this.referenceBlock, "Reference block was null!")), "Reference block resource location was null!").toString());
        if (this.itemTextureRotation != null && this.itemTextureRotation != Direction.NORTH) {
            json.addProperty("item_texture_rotation", this.itemTextureRotation.toString());
        }
        return json;
    }
}

