/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.core.common.util.JsonUtil;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SlicingRecipe
implements MachineRecipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<Ingredient> inputs;
    private final int energy;

    public SlicingRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs, int energy) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
        this.energy = energy;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    @Override
    public List<OutputStack> craft(Container container, RegistryAccess registryAccess) {
        return this.getResultStacks(registryAccess);
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(this.output.m_41777_()));
    }

    public List<Ingredient> getInputs() {
        return List.copyOf(this.inputs);
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.inputs.toArray(new Ingredient[0]));
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (this.inputs.get(i).test(container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.SLICING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.SLICING.type().get();
    }

    public static class Serializer
    implements RecipeSerializer<SlicingRecipe> {
        public SlicingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ItemStack output = JsonUtil.deserializeItemStackWithOldFormat(serializedRecipe.get("output"), true, true);
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            JsonArray inputsJson = serializedRecipe.getAsJsonArray("inputs");
            for (JsonElement itemJson : inputsJson) {
                inputs.add(Ingredient.m_43917_((JsonElement)itemJson));
            }
            int energy = serializedRecipe.get("energy").getAsInt();
            return new SlicingRecipe(recipeId, output, inputs, energy);
        }

        @Nullable
        public SlicingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                ItemStack output = buffer.m_130267_();
                List inputs = (List)buffer.m_236838_(ArrayList::new, Ingredient::m_43940_);
                int energy = buffer.readInt();
                return new SlicingRecipe(recipeId, output, inputs, energy);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading slicing recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, SlicingRecipe recipe) {
            try {
                buffer.m_130055_(recipe.output);
                buffer.m_236828_(recipe.inputs, (buf, ing) -> ing.m_43923_(buf));
                buffer.writeInt(recipe.energy);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing slicing recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

