/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tags.TagUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public final class TagCache {
    private static final Map<String, MatchingStacks> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, MatchingStacks> blockModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<Block, List<String>> tileEntityTypeTagCache = new IdentityHashMap<Block, List<String>>();
    private static final Object2BooleanMap<String> blockTagBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<String> modIDBlacklistedElements = new Object2BooleanOpenHashMap();

    private TagCache() {
    }

    public static void resetTagCaches() {
        blockTagStacks.clear();
        itemTagStacks.clear();
        tileEntityTypeTagCache.clear();
        blockTagBlacklistedElements.clear();
        modIDBlacklistedElements.clear();
    }

    public static List<String> getItemTags(@NotNull ItemStack check) {
        return TagCache.getTagsAsStrings(check.m_204131_());
    }

    public static List<String> getTileEntityTypeTags(@NotNull Block block) {
        return tileEntityTypeTagCache.computeIfAbsent(block, b -> {
            if (b instanceof IHasTileEntity) {
                IHasTileEntity hasTileEntity = (IHasTileEntity)b;
                return TagCache.getTagsAsStrings(TagUtils.tagsStream(ForgeRegistries.BLOCK_ENTITY_TYPES, (BlockEntityType)hasTileEntity.getTileType().get()));
            }
            BlockState state = b.m_49966_();
            if (state.m_155947_()) {
                ITagManager manager = TagUtils.manager(ForgeRegistries.BLOCK_ENTITY_TYPES);
                return TagCache.getTagsAsStrings(StreamSupport.stream(ForgeRegistries.BLOCK_ENTITY_TYPES.spliterator(), false).filter(type -> type.m_155262_(state)).flatMap(type -> TagUtils.tagsStream(manager, type)).distinct());
            }
            return Collections.emptyList();
        });
    }

    public static <TYPE> List<String> getTagsAsStrings(@NotNull Stream<TagKey<TYPE>> tags) {
        return tags.map(tag -> tag.f_203868_().toString()).toList();
    }

    public static List<ItemStack> getItemTagStacks(@NotNull String tagName) {
        return itemTagStacks.computeIfAbsent(tagName, name -> {
            Set<Item> items = TagCache.collectTagStacks(TagUtils.manager(ForgeRegistries.ITEMS), name, item -> item != MekanismBlocks.BOUNDING_BLOCK.m_5456_());
            return items.stream().map(ItemStack::new).filter(stack -> !stack.m_41619_()).toList();
        });
    }

    public static MatchingStacks getBlockTagStacks(@NotNull String tagName) {
        return blockTagStacks.computeIfAbsent(tagName, name -> {
            Set<Block> blocks = TagCache.collectTagStacks(TagUtils.manager(ForgeRegistries.BLOCKS), name, block -> block != MekanismBlocks.BOUNDING_BLOCK.getBlock());
            return TagCache.getMatching(blocks);
        });
    }

    private static <TYPE extends ItemLike> Set<TYPE> collectTagStacks(ITagManager<TYPE> tagManager, String tagName, Predicate<TYPE> validElement) {
        return tagManager.stream().filter(tag -> WildcardMatcher.matches(tagName, tag.getKey())).flatMap(ITag::stream).filter(validElement).collect(Collectors.toSet());
    }

    private static MatchingStacks getMatching(Set<Block> blocks) {
        if (blocks.isEmpty()) {
            return MatchingStacks.NONE;
        }
        return new MatchingStacks(true, blocks.stream().map(ItemStack::new).filter(stack -> !stack.m_41619_()).toList());
    }

    public static List<ItemStack> getItemModIDStacks(@NotNull String modName) {
        return itemModIDStacks.computeIfAbsent(modName, name -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack stack;
                if (item == MekanismBlocks.BOUNDING_BLOCK.m_5456_() || (stack = new ItemStack((ItemLike)item)).m_41619_() || !WildcardMatcher.matches(name, MekanismUtils.getModId(stack))) continue;
                stacks.add(stack);
            }
            return stacks;
        });
    }

    public static MatchingStacks getBlockModIDStacks(@NotNull String modName) {
        return blockModIDStacks.computeIfAbsent(modName, name -> {
            ReferenceOpenHashSet blocks = new ReferenceOpenHashSet();
            for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                Block block = (Block)entry.getValue();
                if (block == MekanismBlocks.BOUNDING_BLOCK.getBlock() || !WildcardMatcher.matches(name, ((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
                blocks.add(block);
            }
            return TagCache.getMatching((Set<Block>)blocks);
        });
    }

    public static boolean tagHasMinerBlacklisted(@NotNull String tag) {
        if (MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.isEmpty()) {
            return false;
        }
        return blockTagBlacklistedElements.computeIfAbsent((Object)tag, t -> TagUtils.manager(ForgeRegistries.BLOCKS).stream().anyMatch(blockTag -> {
            if (!WildcardMatcher.matches(t, blockTag.getKey())) return false;
            if (!blockTag.stream().anyMatch(MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP::contains)) return false;
            return true;
        }));
    }

    public static boolean modIDHasMinerBlacklisted(@NotNull String modName) {
        if (MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.isEmpty()) {
            return false;
        }
        return modIDBlacklistedElements.computeIfAbsent((Object)modName, name -> {
            for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                Block block = (Block)entry.getValue();
                if (!MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.contains(block) || !WildcardMatcher.matches(name, ((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
                return true;
            }
            return false;
        });
    }

    public record MatchingStacks(boolean hasMatch, List<ItemStack> stacks) {
        private static final MatchingStacks NONE = new MatchingStacks(false, Collections.emptyList());
    }
}

