/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.StatsMap;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class ColumnRenderBuffer
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper minecraftClient = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final long MAX_BUFFER_UPLOAD_TIMEOUT_NANOSECONDS = 1000000L;
    public static final int QUADS_BYTE_SIZE = LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 4;
    public static final int MAX_VBO_BYTE_SIZE = 0xA00000;
    public static final int MAX_QUADS_PER_BUFFER = 0xA00000 / QUADS_BYTE_SIZE;
    public static final int FULL_SIZED_BUFFER = MAX_QUADS_PER_BUFFER * QUADS_BYTE_SIZE;
    public final DhBlockPos pos;
    public boolean buffersUploaded = false;
    private GLVertexBuffer[] vbos;
    private GLVertexBuffer[] vbosTransparent;

    public ColumnRenderBuffer(DhBlockPos pos) {
        this.pos = pos;
        this.vbos = new GLVertexBuffer[0];
        this.vbosTransparent = new GLVertexBuffer[0];
    }

    public void uploadBuffer(LodQuadBuilder builder, EDhApiGpuUploadMethod gpuUploadMethod) throws InterruptedException {
        LodUtil.assertTrue(DhApi.isDhThread(), "Buffer uploading needs to be done on a DH thread to prevent locking up any MC threads.");
        CompletableFuture uploadFuture = new CompletableFuture();
        minecraftClient.executeOnRenderThread(() -> {
            try {
                this.uploadBuffers(builder, gpuUploadMethod);
                uploadFuture.complete(null);
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        });
        try {
            uploadFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOGGER.warn("Error uploading builder [" + builder + "] synchronously. Error: " + e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private void uploadBuffers(LodQuadBuilder builder, EDhApiGpuUploadMethod method) throws InterruptedException {
        this.vbos = ColumnRenderBuffer.makeAndUploadBuffers(builder, method, this.vbos, builder.makeOpaqueVertexBuffers());
        this.vbosTransparent = ColumnRenderBuffer.makeAndUploadBuffers(builder, method, this.vbosTransparent, builder.makeTransparentVertexBuffers());
        this.buffersUploaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GLVertexBuffer[] makeAndUploadBuffers(LodQuadBuilder builder, EDhApiGpuUploadMethod method, GLVertexBuffer[] vbos, ArrayList<ByteBuffer> buffers) throws InterruptedException {
        try {
            vbos = ColumnRenderBuffer.resizeBuffer(vbos, buffers.size());
            ColumnRenderBuffer.uploadBuffersDirect(vbos, buffers, method);
        }
        finally {
            if (buffers != null) {
                for (ByteBuffer buffer : buffers) {
                    MemoryUtil.memFree((Buffer)buffer);
                }
            }
        }
        return vbos;
    }

    private static void uploadBuffersDirect(GLVertexBuffer[] vbos, ArrayList<ByteBuffer> byteBuffers, EDhApiGpuUploadMethod method) throws InterruptedException {
        int vboIndex = 0;
        for (int i = 0; i < byteBuffers.size(); ++i) {
            if (vboIndex >= vbos.length) {
                throw new RuntimeException("Too many vertex buffers!!");
            }
            if (vbos[vboIndex] == null) {
                vbos[vboIndex] = new GLVertexBuffer(method.useBufferStorage);
            }
            GLVertexBuffer vbo = vbos[vboIndex];
            ByteBuffer buffer = byteBuffers.get(i);
            int size = buffer.limit() - buffer.position();
            try {
                vbo.bind();
                vbo.uploadBuffer(buffer, size / LodUtil.LOD_VERTEX_FORMAT.getByteSize(), method, FULL_SIZED_BUFFER);
            }
            catch (Exception e) {
                vbos[vboIndex] = null;
                vbo.close();
                LOGGER.error("Failed to upload buffer: ", (Throwable)e);
            }
            ++vboIndex;
        }
        if (vboIndex < vbos.length) {
            throw new RuntimeException("Too few vertex buffers!!");
        }
    }

    public boolean renderOpaque(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        boolean hasRendered = false;
        renderContext.setModelViewMatrixOffset(this.pos, renderEventParam);
        for (GLVertexBuffer vbo : this.vbos) {
            if (vbo == null || vbo.getVertexCount() == 0) continue;
            hasRendered = true;
            renderContext.drawVbo(vbo);
        }
        return hasRendered;
    }

    public boolean renderTransparent(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        boolean hasRendered = false;
        try {
            renderContext.setModelViewMatrixOffset(this.pos, renderEventParam);
            for (GLVertexBuffer vbo : this.vbosTransparent) {
                if (vbo == null || vbo.getVertexCount() == 0) continue;
                hasRendered = true;
                renderContext.drawVbo(vbo);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("renderContext program doesn't exist for pos: " + this.pos, (Throwable)e);
        }
        return hasRendered;
    }

    public boolean hasNonNullVbos() {
        return this.vbos != null || this.vbosTransparent != null;
    }

    public int vboBufferCount() {
        int count = 0;
        if (this.vbos != null) {
            count += this.vbos.length;
        }
        if (this.vbosTransparent != null) {
            count += this.vbosTransparent.length;
        }
        return count;
    }

    public void debugDumpStats(StatsMap statsMap) {
        statsMap.incStat("RenderBuffers");
        statsMap.incStat("SimpleRenderBuffers");
        for (GLVertexBuffer vertexBuffer : this.vbos) {
            if (vertexBuffer == null) continue;
            statsMap.incStat("VBOs");
            if (vertexBuffer.getSize() == FULL_SIZED_BUFFER) {
                statsMap.incStat("FullsizedVBOs");
            }
            if (vertexBuffer.getSize() == 0) {
                GLProxy.GL_LOGGER.warn("VBO with size 0", new Object[0]);
            }
            statsMap.incBytesStat("TotalUsage", vertexBuffer.getSize());
        }
    }

    public static GLVertexBuffer[] resizeBuffer(GLVertexBuffer[] vbos, int newSize) {
        if (vbos.length == newSize) {
            return vbos;
        }
        GLVertexBuffer[] newVbos = new GLVertexBuffer[newSize];
        System.arraycopy(vbos, 0, newVbos, 0, Math.min(vbos.length, newSize));
        if (newSize < vbos.length) {
            for (int i = newSize; i < vbos.length; ++i) {
                if (vbos[i] == null) continue;
                vbos[i].close();
            }
        }
        return newVbos;
    }

    @Override
    public void close() {
        this.buffersUploaded = false;
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            for (GLVertexBuffer buffer : this.vbos) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
            for (GLVertexBuffer buffer : this.vbosTransparent) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
        });
    }
}

