/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ChunkHashRepo
extends AbstractDhRepo<DhChunkPos, ChunkHashDTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public ChunkHashRepo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, ChunkHashDTO.class);
    }

    @Override
    public String getTableName() {
        return "ChunkHash";
    }

    @Override
    public String createWhereStatement(DhChunkPos pos) {
        return "ChunkPosX = '" + pos.getX() + "' AND ChunkPosZ = '" + pos.getZ() + "'";
    }

    @Override
    public ChunkHashDTO convertDictionaryToDto(Map<String, Object> objectMap) throws ClassCastException {
        int posX = (Integer)objectMap.get("ChunkPosX");
        int posZ = (Integer)objectMap.get("ChunkPosZ");
        int chunkHash = (Integer)objectMap.get("ChunkHash");
        ChunkHashDTO dto = new ChunkHashDTO(new DhChunkPos(posX, posZ), chunkHash);
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(ChunkHashDTO dto) throws SQLException {
        String sql = "INSERT INTO " + this.getTableName() + " (\n   ChunkPosX, ChunkPosZ, \n   ChunkHash, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, \n    ?, \n    ?, ? \n);";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.pos.getX());
        statement.setObject(i++, dto.pos.getZ());
        statement.setObject(i++, dto.chunkHash);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(ChunkHashDTO dto) throws SQLException {
        String sql = "UPDATE " + this.getTableName() + " \nSET \n    ChunkHash = ? \n   ,LastModifiedUnixDateTime = ? \nWHERE ChunkPosX = ? AND ChunkPosZ = ?";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.chunkHash);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, dto.pos.getX());
        statement.setObject(i++, dto.pos.getZ());
        return statement;
    }
}

