/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.RateLimitedThreadPoolExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String THREAD_NAME_PREFIX = "DH-";
    private static final ConcurrentHashMap<String, ConfigChangeListener<Double>> THREAD_CHANGE_LISTENERS_BY_THREAD_NAME = new ConcurrentHashMap();

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, DhThreadFactory threadFactory, ConfigEntry<Double> runTimeRatioConfigEntry, Semaphore activeThreadCountSemaphore) {
        if (THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.containsKey(threadFactory.threadName)) {
            THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.get(threadFactory.threadName).close();
            THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.remove(threadFactory.threadName);
        }
        if (!threadFactory.threadName.startsWith(THREAD_NAME_PREFIX)) {
            LOGGER.warn("Thread pool with the name [" + threadFactory.threadName + "] is missing the expected Distant Horizons thread prefix [" + THREAD_NAME_PREFIX + "].");
        }
        RateLimitedThreadPoolExecutor executor = ThreadUtil.makeRateLimitedThreadPool(poolSize, runTimeRatioConfigEntry.get(), threadFactory, activeThreadCountSemaphore);
        ConfigChangeListener<Double> changeListener = new ConfigChangeListener<Double>(runTimeRatioConfigEntry, newRunTimeRatio -> {
            executor.runTimeRatio = newRunTimeRatio;
        });
        THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.put(threadFactory.threadName, changeListener);
        return executor;
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, String name, Double runTimeRatio, int threadPriority, Semaphore activeThreadCountSemaphore) {
        return new RateLimitedThreadPoolExecutor(poolSize, runTimeRatio, new DhThreadFactory(name, threadPriority), activeThreadCountSemaphore);
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, Double runTimeRatio, DhThreadFactory threadFactory, Semaphore activeThreadCountSemaphore) {
        return new RateLimitedThreadPoolExecutor(poolSize, runTimeRatio, threadFactory, activeThreadCountSemaphore);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name, int priority) {
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DhThreadFactory(name, priority));
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz, int priority) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), priority);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name) {
        return ThreadUtil.makeThreadPool(poolSize, name, 5);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), 5);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name, int priority) {
        return ThreadUtil.makeThreadPool(1, name, priority);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz, int priority) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), priority);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name) {
        return ThreadUtil.makeThreadPool(1, name, 5);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), 5);
    }
}

