/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RateLimitedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final boolean LOG_SEMAPHORE_ACTIONS = false;
    public volatile double runTimeRatio;
    private final ThreadLocal<Long> runStartNanoTimeRef = ThreadLocal.withInitial(() -> -1L);
    private final ThreadLocal<Long> lastRunDurationNanoTimeRef = ThreadLocal.withInitial(() -> -1L);
    private Runnable onTerminatedEventHandler = null;
    @Nullable
    private final Semaphore activeThreadCountSemaphore;
    private final AtomicInteger semaphoresAcquired = new AtomicInteger(0);

    public RateLimitedThreadPoolExecutor(int corePoolSize, double runTimeRatio, ThreadFactory threadFactory) {
        this(corePoolSize, runTimeRatio, threadFactory, null);
    }

    public RateLimitedThreadPoolExecutor(int corePoolSize, double runTimeRatio, ThreadFactory threadFactory, @Nullable Semaphore activeThreadCountSemaphore) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.runTimeRatio = runTimeRatio;
        this.activeThreadCountSemaphore = activeThreadCountSemaphore;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        if (this.runTimeRatio < 1.0 && this.lastRunDurationNanoTimeRef.get() != -1L) {
            try {
                long deltaMs = TimeUnit.NANOSECONDS.toMillis(this.lastRunDurationNanoTimeRef.get());
                Thread.sleep((long)((double)deltaMs / this.runTimeRatio - (double)deltaMs));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.activeThreadCountSemaphore != null) {
            try {
                this.activeThreadCountSemaphore.acquire();
                this.semaphoresAcquired.getAndAdd(1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.runStartNanoTimeRef.set(System.nanoTime());
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        this.lastRunDurationNanoTimeRef.set(System.nanoTime() - this.runStartNanoTimeRef.get());
        if (this.activeThreadCountSemaphore != null) {
            this.activeThreadCountSemaphore.release();
            this.semaphoresAcquired.getAndAdd(-1);
        }
    }

    @Override
    protected void terminated() {
        super.terminated();
        if (this.onTerminatedEventHandler != null) {
            this.onTerminatedEventHandler.run();
        }
        if (this.activeThreadCountSemaphore != null) {
            int semaphoresAcquired = this.semaphoresAcquired.getAndSet(0);
            this.activeThreadCountSemaphore.release(semaphoresAcquired);
        }
    }

    public void setOnTerminatedEventHandler(Runnable runnable) {
        this.onTerminatedEventHandler = runnable;
    }
}

