/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.client;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiEndergenic
extends GenericGuiContainer<EndergenicTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private TextField lastRfPerTick;
    private TextField lastLostPearls;
    private TextField lastLaunchedPearls;
    private TextField lastOpportunities;
    private int timer = 10;

    public GuiEndergenic(EndergenicTileEntity endergenicTileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)endergenicTileEntity, (AbstractContainerMenu)container, inventory, ((BaseBlock)EndergenicModule.ENDERGENIC.get()).getManualEntry());
    }

    public static void register() {
        GuiEndergenic.register(EndergenicModule.CONTAINER_ENDERGENIC.get(), GuiEndergenic::new);
    }

    public void m_7856_() {
        this.window = new Window((Screen)this, this.tileEntity, new ResourceLocation("rftoolspower", "gui/endergenic.gui"));
        super.m_7856_();
        this.initializeFields();
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.lastRfPerTick = (TextField)this.window.findChild("lastrft");
        this.lastLostPearls = (TextField)this.window.findChild("lastlost");
        this.lastLaunchedPearls = (TextField)this.window.findChild("lastlaunched");
        this.lastOpportunities = (TextField)this.window.findChild("lastopp");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        this.energyBar.maxValue(((EndergenicTileEntity)this.tileEntity).getCapacity());
        this.lastRfPerTick.text(((EndergenicTileEntity)this.tileEntity).clientLastRfPerTick + " RF/tick");
        this.lastLostPearls.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlsLost + " pearls");
        this.lastLaunchedPearls.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlsLaunched + " pearls");
        this.lastOpportunities.text(((EndergenicTileEntity)this.tileEntity).clientLastPearlOpportunities + " times");
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float v, int i, int i2) {
        this.updateFields();
        this.drawWindow(graphics);
        this.checkStats();
    }

    private void checkStats() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 20;
            Networking.sendToServer((Object)PacketRequestDataFromServer.create((ResourceKey)((EndergenicTileEntity)this.tileEntity).getDimension(), (BlockPos)((EndergenicTileEntity)this.tileEntity).m_58899_(), (String)EndergenicTileEntity.CMD_GETSTATS.name(), (TypedMap)TypedMap.EMPTY, (boolean)false));
        }
        this.updateEnergyBar(this.energyBar);
    }
}

