/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client.gui;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.PlayerGUIOperationMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class MemberButton
extends NordButton {
    private final KnownClientPlayer player;

    MemberButton(Panel panel, KnownClientPlayer p) {
        super(panel, (Component)Component.m_237113_((String)p.name()), (Icon)FaceIcon.getFace((GameProfile)p.profile()));
        this.setWidth(this.width + 18);
        this.player = p;
    }

    public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        ClientTeam selfTeam;
        super.drawIcon(graphics, theme, x, y, w, h);
        if (this.player.online()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)(x + w) - 1.5, (double)y - 0.5, 0.0);
            Color4I.GREEN.draw(graphics, 0, 0, 2, 2);
            graphics.m_280168_().m_85849_();
        }
        if ((selfTeam = ClientTeamManagerImpl.getInstance().selfTeam()).getType() == TeamType.PARTY) {
            TeamRank tr = selfTeam.getRankForPlayer(this.player.id());
            tr.getIcon().ifPresent(icon -> icon.draw(graphics, this.getX() + this.width - 14, this.getY() + 2, 12, 12));
        }
    }

    public void onClicked(MouseButton button) {
        KnownClientPlayer self = ClientTeamManagerImpl.getInstance().self();
        ClientTeam selfTeam = ClientTeamManagerImpl.getInstance().selfTeam();
        if (selfTeam == null || self == null) {
            return;
        }
        TeamRank selfRank = selfTeam.getRankForPlayer(self.id());
        TeamRank playerRank = selfTeam.getRankForPlayer(this.player.id());
        if (selfTeam.getType() != TeamType.PARTY) {
            return;
        }
        ArrayList<ContextMenuItem> items0 = new ArrayList<ContextMenuItem>();
        if (this.player.id().equals(self.id())) {
            if (selfRank.isAtLeast(TeamRank.OWNER)) {
                if (selfTeam.getMembers().size() == 1) {
                    items0.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbteams.gui.disband"), Icons.CLOSE, b -> PlayerGUIOperationMessage.Operation.LEAVE.sendMessage(this.player)).setYesNoText((Component)Component.m_237115_((String)"ftbteams.gui.disband.confirm")));
                }
            } else {
                items0.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbteams.gui.leave"), Icons.CLOSE, b -> PlayerGUIOperationMessage.Operation.LEAVE.sendMessage(this.player)).setYesNoText((Component)Component.m_237115_((String)"ftbteams.gui.leave.confirm")));
            }
        } else if (selfRank.isAtLeast(TeamRank.OWNER)) {
            if (playerRank == TeamRank.MEMBER) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.promote", (Object[])new Object[]{this.player.name()}), Icons.SHIELD, b -> PlayerGUIOperationMessage.Operation.PROMOTE.sendMessage(this.player)).setYesNoText((Component)Component.m_237110_((String)"ftbteams.gui.promote.confirm", (Object[])new Object[]{this.player.name()})));
            } else if (playerRank == TeamRank.OFFICER) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.demote", (Object[])new Object[]{this.player.name()}), Icons.ACCEPT_GRAY, b -> PlayerGUIOperationMessage.Operation.DEMOTE.sendMessage(this.player)).setYesNoText((Component)Component.m_237110_((String)"ftbteams.gui.demote.confirm", (Object[])new Object[]{this.player.name()})));
            }
            if (playerRank.isMemberOrBetter()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.transfer_ownership", (Object[])new Object[]{this.player.name()}), Icons.DIAMOND, b -> PlayerGUIOperationMessage.Operation.TRANSFER_OWNER.sendMessage(this.player)).setYesNoText((Component)Component.m_237110_((String)"ftbteams.gui.transfer_ownership.confirm", (Object[])new Object[]{this.player.name()})));
            }
        }
        if (selfRank.getPower() > playerRank.getPower()) {
            if (playerRank.isMemberOrBetter()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.kick", (Object[])new Object[]{this.player.name()}), Icons.CLOSE, b -> PlayerGUIOperationMessage.Operation.KICK.sendMessage(this.player)).setYesNoText((Component)Component.m_237110_((String)"ftbteams.gui.kick.confirm", (Object[])new Object[]{this.player.name()})));
            } else if (selfRank.isOfficerOrBetter() && playerRank.isAllyOrBetter()) {
                items0.add(new ContextMenuItem((Component)Component.m_237110_((String)"ftbteams.gui.remove_ally", (Object[])new Object[]{this.player.name()}), Icons.CANCEL, b -> PlayerGUIOperationMessage.Operation.REMOVE_ALLY.sendMessage(this.player)).setYesNoText((Component)Component.m_237110_((String)"ftbteams.gui.remove_ally.confirm", (Object[])new Object[]{this.player.name()})));
            }
        }
        if (!items0.isEmpty()) {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>(List.of(new ContextMenuItem(playerRank.getDisplayName(), (Icon)FaceIcon.getFace((GameProfile)new GameProfile(this.player.id(), null)), null).setCloseMenu(false), ContextMenuItem.SEPARATOR));
            items.addAll(items0);
            this.getGui().openContextMenu(items);
        }
    }
}

