/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.network;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateConfig {
    private final List<UnmodifiableConfig> cats;
    private final List<String> rules;
    private final List<UnmodifiableConfig> contOverrides;
    private final boolean autoRefill;

    public PacketUpdateConfig() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }

    public PacketUpdateConfig(List<UnmodifiableConfig> cats, List<String> rules, List<UnmodifiableConfig> contOverrides, boolean autoRefill) {
        this.cats = cats;
        this.rules = rules;
        this.autoRefill = autoRefill;
        this.contOverrides = contOverrides;
    }

    public PacketUpdateConfig(FriendlyByteBuf buf) {
        this.cats = new ArrayList<UnmodifiableConfig>();
        int catsSize = buf.m_130242_();
        for (int i = 0; i < catsSize; ++i) {
            CommentedConfig subCfg = CommentedConfig.inMemory();
            subCfg.set("name", (Object)buf.m_130136_(Short.MAX_VALUE));
            ArrayList<String> spec = new ArrayList<String>();
            int specSize = buf.m_130242_();
            for (int j = 0; j < specSize; ++j) {
                spec.add(buf.m_130136_(Short.MAX_VALUE));
            }
            subCfg.set("spec", spec);
            this.cats.add((UnmodifiableConfig)subCfg);
        }
        this.rules = new ArrayList<String>();
        int rulesSize = buf.m_130242_();
        for (int i = 0; i < rulesSize; ++i) {
            this.rules.add(buf.m_130136_(Short.MAX_VALUE));
        }
        this.contOverrides = new ArrayList<UnmodifiableConfig>();
        int contOverridesSize = buf.m_130242_();
        for (int i = 0; i < contOverridesSize; ++i) {
            CommentedConfig contOverride = CommentedConfig.inMemory();
            contOverride.set("containerClass", (Object)buf.m_130136_(Short.MAX_VALUE));
            contOverride.set("x", (Object)buf.readInt());
            contOverride.set("y", (Object)buf.readInt());
            contOverride.set("sortRange", (Object)buf.m_130136_(Short.MAX_VALUE));
            this.contOverrides.add((UnmodifiableConfig)contOverride);
        }
        this.autoRefill = buf.readBoolean();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            InvTweaksConfig.setPlayerCats((Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), InvTweaksConfig.cfgToCompiledCats(this.cats));
            InvTweaksConfig.setPlayerRules((Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), new Ruleset(this.rules));
            InvTweaksConfig.setPlayerAutoRefill((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.autoRefill);
            InvTweaksConfig.setPlayerContOverrides((Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), InvTweaksConfig.cfgToCompiledContOverrides(this.contOverrides));
        });
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.cats.size());
        for (UnmodifiableConfig subCfg : this.cats) {
            buf.m_130070_((String)subCfg.getOrElse("name", (Object)""));
            List spec = (List)subCfg.getOrElse("spec", Collections.emptyList());
            buf.m_130130_(spec.size());
            for (String subSpec : spec) {
                buf.m_130070_(subSpec);
            }
        }
        buf.m_130130_(this.rules.size());
        for (String subRule : this.rules) {
            buf.m_130070_(subRule);
        }
        buf.m_130130_(this.contOverrides.size());
        for (UnmodifiableConfig contOverride : this.contOverrides) {
            buf.m_130070_((String)contOverride.getOrElse("containerClass", (Object)""));
            int x = contOverride.getIntOrElse("x", -1418392593);
            int y = contOverride.getIntOrElse("y", -1418392593);
            buf.writeInt(x).writeInt(y);
            buf.m_130070_((String)contOverride.getOrElse("sortRange", (Object)"default"));
        }
        buf.writeBoolean(this.autoRefill);
    }
}

