/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals;

import com.hakimen.peripherals.MorePeripheralsClient;
import com.hakimen.peripherals.blocks.tile_entities.FacadedBlockEntity;
import com.hakimen.peripherals.client.ber.AdvancedDiskRaidRenderer;
import com.hakimen.peripherals.client.ber.DiskRaidRenderer;
import com.hakimen.peripherals.client.ber.MagneticCardManipulatorRenderer;
import com.hakimen.peripherals.client.ber.ScannerRenderer;
import com.hakimen.peripherals.client.model.CableBakedModel;
import com.hakimen.peripherals.config.Config;
import com.hakimen.peripherals.items.MagneticCardItem;
import com.hakimen.peripherals.registry.BlockEntityRegister;
import com.hakimen.peripherals.registry.BlockRegister;
import com.hakimen.peripherals.registry.ComputerCraftRegister;
import com.hakimen.peripherals.registry.ContainerRegister;
import com.hakimen.peripherals.registry.ItemRegister;
import com.hakimen.peripherals.registry.PacketRegister;
import com.hakimen.peripherals.utils.EnchantUtils;
import dan200.computercraft.shared.ModRegistry;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="peripherals")
@Mod.EventBusSubscriber(modid="peripherals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MorePeripherals {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String mod_id = "peripherals";

    public MorePeripherals() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EnchantUtils.init();
        BlockEntityRegister.register(bus);
        ItemRegister.register(bus);
        BlockRegister.register(bus);
        ContainerRegister.register(bus);
        ComputerCraftRegister.registerTurtleUpgrades(bus);
        ComputerCraftRegister.registerPeripheralProvider();
        PacketRegister.register();
        bus.addListener(this::setup);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::processIMC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonConfigSpec, "more-peripherals-common.toml");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(MorePeripheralsClient::clientInit));
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @Mod.EventBusSubscriber(modid="peripherals", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegister.scanner.get(), ScannerRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegister.diskRaidEntity.get(), DiskRaidRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegister.advancedDiskRaidEntity.get(), AdvancedDiskRaidRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegister.magneticCardManipulator.get(), MagneticCardManipulatorRenderer::new);
        }

        @SubscribeEvent
        public static void onModifyBakingEvent(ModelEvent.ModifyBakingResult event) {
            for (Map.Entry entry : event.getModels().entrySet()) {
                ModelResourceLocation location;
                Object k = entry.getKey();
                if (!(k instanceof ModelResourceLocation) || !(location = (ModelResourceLocation)k).m_135827_().equals("computercraft") || !location.m_135815_().equals("cable")) continue;
                event.getModels().put((ResourceLocation)entry.getKey(), new CableBakedModel((BakedModel)entry.getValue()));
            }
        }

        @SubscribeEvent
        public static void registerColours(RegisterColorHandlersEvent.Block event) {
            event.register((state, level, pos, layer) -> {
                FacadedBlockEntity facaded;
                BlockEntity patt4553$temp;
                return level != null && pos != null && (patt4553$temp = level.m_7702_(pos)) instanceof FacadedBlockEntity && !(facaded = (FacadedBlockEntity)patt4553$temp).getFacade().m_60795_() ? Minecraft.m_91087_().m_91298_().m_92577_(facaded.getFacade(), level, pos, layer) : -1;
            }, new Block[]{(Block)ModRegistry.Blocks.CABLE.get()});
        }

        @SubscribeEvent
        public static void registerColours(RegisterColorHandlersEvent.Item event) {
            event.register((stack, layer) -> layer == 1 ? -1 : ((MagneticCardItem)ItemRegister.magnetic_card.get()).m_41121_(stack), new ItemLike[]{(ItemLike)ItemRegister.magnetic_card.get()});
        }
    }
}

