/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.blocks.tile_entities;

import com.hakimen.peripherals.registry.BlockEntityRegister;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.impl.MediaProviders;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedDiskRaidEntity
extends BlockEntity {
    public final ItemStackHandler inventory = this.createHandler();
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.inventory);
    public Mount[] mounts = new Mount[10];
    public final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();

    public AdvancedDiskRaidEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.advancedDiskRaidEntity.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag);
        super.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_187480_);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128391_(this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void mount(int i, IComputerAccess computer) {
        this.computers.put(computer, new MountInfo());
        this.mountDisk(i, computer);
    }

    public void unmount(int i, IComputerAccess computer) {
        this.unmountDisk(i, computer);
        this.computers.remove(computer);
    }

    private IMedia getDiskMedia(int i) {
        return MediaProviders.get((ItemStack)this.inventory.getStackInSlot(i));
    }

    public void m_6596_() {
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    private synchronized void mountDisk(int i, IComputerAccess computer) {
        if (!this.inventory.getStackInSlot(i).m_41619_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            MountInfo info = this.computers.get(computer);
            IMedia contents = this.getDiskMedia(i);
            if (contents != null) {
                if (this.mounts[i] == null) {
                    this.mounts[i] = contents.createDataMount(this.inventory.getStackInSlot(i), (ServerLevel)this.m_58904_());
                }
                if (this.mounts[i] != null) {
                    if (this.mounts[i] instanceof WritableMount) {
                        int n = 1;
                        while (info.mountPaths[i] == null) {
                            info.mountPaths[i] = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), (WritableMount)this.mounts[i]);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPaths[i] == null) {
                            info.mountPaths[i] = computer.mount((String)(n == 1 ? "disk" : "disk" + n), this.mounts[i]);
                            ++n;
                        }
                    }
                } else {
                    info.mountPaths[i] = null;
                }
            }
            computer.queueEvent("disk", new Object[]{computer.getAttachmentName()});
        }
    }

    private synchronized void unmountDisk(int i, IComputerAccess computer) {
        if (this.inventory.getStackInSlot(i) != ItemStack.f_41583_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            MountInfo info = this.computers.get(computer);
            if (info != null) {
                if (info.mountPaths[i] != null) {
                    computer.unmount(info.mountPaths[i]);
                    info.mountPaths[i] = null;
                }
                computer.queueEvent("disk_eject", new Object[]{computer.getAttachmentName()});
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction dir) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler;
        }
        return super.getCapability(cap, dir);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(10){

            protected void onContentsChanged(int slot) {
                AdvancedDiskRaidEntity.this.m_6596_();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (AdvancedDiskRaidEntity.this.m_58904_().f_46443_) {
                    super.setStackInSlot(slot, stack);
                    AdvancedDiskRaidEntity.this.mounts[slot] = null;
                    AdvancedDiskRaidEntity.this.m_6596_();
                    return;
                }
                1 var3_3 = this;
                synchronized (var3_3) {
                    Set<IComputerAccess> iter;
                    if (Utils.canMergeItems(stack, AdvancedDiskRaidEntity.this.inventory.getStackInSlot(slot))) {
                        super.extractItem(slot, 1, false);
                        return;
                    }
                    if (!AdvancedDiskRaidEntity.this.inventory.getStackInSlot(slot).m_41619_()) {
                        iter = AdvancedDiskRaidEntity.this.computers.keySet();
                        for (IComputerAccess computer : iter) {
                            AdvancedDiskRaidEntity.this.unmountDisk(slot, computer);
                        }
                    }
                    super.setStackInSlot(slot, stack);
                    AdvancedDiskRaidEntity.this.mounts[slot] = null;
                    AdvancedDiskRaidEntity.this.m_6596_();
                    if (!AdvancedDiskRaidEntity.this.inventory.getStackInSlot(slot).m_41619_()) {
                        iter = AdvancedDiskRaidEntity.this.computers.keySet();
                        for (IComputerAccess computer : iter) {
                            AdvancedDiskRaidEntity.this.mountDisk(slot, computer);
                        }
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof DiskItem || stack.m_41720_() instanceof PocketComputerItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!AdvancedDiskRaidEntity.this.inventory.getStackInSlot(slot).m_41619_()) {
                    Set<IComputerAccess> iter = AdvancedDiskRaidEntity.this.computers.keySet();
                    for (IComputerAccess computer : iter) {
                        AdvancedDiskRaidEntity.this.unmountDisk(slot, computer);
                    }
                }
                ItemStack stack = super.extractItem(slot, amount, simulate);
                AdvancedDiskRaidEntity.this.mounts[slot] = null;
                AdvancedDiskRaidEntity.this.m_6596_();
                return stack;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static class MountInfo {
        public String[] mountPaths = new String[10];
    }
}

