/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.client.model;

import com.hakimen.peripherals.blocks.tile_entities.FacadedBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final Direction[] RENDER_DIRECTIONS = new Direction[]{null, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public CableBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType type) {
        BlockState facade = (BlockState)data.get(FacadedBlockEntity.PROPERTY);
        if (facade == null || facade.m_60795_() || side != null) {
            return super.getQuads(state, side, rand, data, type);
        }
        BakedModel model = CableBakedModel.getBlockModel(facade);
        if (type != null && !model.getRenderTypes(facade, rand, data).contains(type)) {
            return super.getQuads(state, null, rand, data, type);
        }
        ArrayList<List> quads = new ArrayList<List>(7);
        quads.add(super.getQuads(state, null, rand, data, type));
        for (Direction direction : RENDER_DIRECTIONS) {
            quads.add(model.getQuads(facade, direction, rand, data, type));
        }
        return ConcatenatedListView.of(quads);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState facade = (BlockState)data.get(FacadedBlockEntity.PROPERTY);
        return facade == null || facade.m_60795_() ? super.getRenderTypes(state, rand, data) : ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{super.getRenderTypes(state, rand, data), CableBakedModel.getBlockModel(facade).getRenderTypes(facade, rand, data)});
    }

    private static BakedModel getBlockModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }
}

