/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.items;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IDyedItem
extends DyeableLeatherItem {
    public static final String TAG_COLOR = "color";
    public static final String TAG_DISPLAY = "display";
    public static final int DEFAULT_COLOR = 0xFFFFFF;

    default public boolean m_41113_(ItemStack p_41114_) {
        CompoundTag compoundtag = p_41114_.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_COLOR, 99);
    }

    default public int m_41121_(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_(TAG_DISPLAY);
        return compoundtag != null && compoundtag.m_128425_(TAG_COLOR, 99) ? compoundtag.m_128451_(TAG_COLOR) : 0xFFFFFF;
    }

    default public void m_41123_(ItemStack p_41124_) {
        CompoundTag compoundtag = p_41124_.m_41737_(TAG_DISPLAY);
        if (compoundtag != null && compoundtag.m_128441_(TAG_COLOR)) {
            compoundtag.m_128473_(TAG_COLOR);
        }
    }

    default public void m_41115_(ItemStack stack, int color) {
        stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_COLOR, color);
    }

    public static ItemStack dyeArmor(ItemStack stack, List<DyeItem> dyes) {
        ItemStack itemstack = ItemStack.f_41583_;
        int[] rgb = new int[3];
        int i = 0;
        int j = 0;
        Item item = stack.m_41720_();
        IDyedItem iDyedItem = null;
        if (item instanceof IDyedItem) {
            iDyedItem = (IDyedItem)item;
            itemstack = stack.m_255036_(1);
            if (iDyedItem.m_41113_(stack)) {
                int k = iDyedItem.m_41121_(itemstack);
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                i += (int)(Math.max(f, Math.max(f1, f2)) * 255.0f);
                rgb[0] = rgb[0] + (int)(f * 255.0f);
                rgb[1] = rgb[1] + (int)(f1 * 255.0f);
                rgb[2] = rgb[2] + (int)(f2 * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : dyes) {
                float[] dyeDiffuseRGB = dyeitem.m_41089_().m_41068_();
                int r = (int)(dyeDiffuseRGB[0] * 255.0f);
                int g = (int)(dyeDiffuseRGB[1] * 255.0f);
                int b = (int)(dyeDiffuseRGB[2] * 255.0f);
                i += Math.max(r, Math.max(g, b));
                rgb[0] = rgb[0] + r;
                rgb[1] = rgb[1] + g;
                rgb[2] = rgb[2] + b;
                ++j;
            }
        }
        if (iDyedItem == null) {
            return ItemStack.f_41583_;
        }
        int r = rgb[0] / j;
        int g = rgb[1] / j;
        int b = rgb[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(r, Math.max(g, b));
        r = (int)((float)r * f3 / f4);
        g = (int)((float)g * f3 / f4);
        b = (int)((float)b * f3 / f4);
        int finalRGB = (r << 8) + g;
        finalRGB = (finalRGB << 8) + b;
        iDyedItem.m_41115_(itemstack, finalRGB);
        return itemstack;
    }
}

