/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.BeehiveInterfaceEntity;
import com.hakimen.peripherals.registry.BlockRegister;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.io.Serializable;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeehiveInterfacePeripheral
implements IPeripheral,
IPeripheralProvider {
    BeehiveInterfaceEntity tileEntity;

    @NotNull
    public String getType() {
        return "beehive_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasBees() {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        return MethodResult.of((Object)(!this.tileEntity.beehiveBlockEntity.m_58774_() ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getBeeCount() {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        return MethodResult.of((Object[])new Object[]{true, this.tileEntity.beehiveBlockEntity.m_58776_()});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult gotFireNear() {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        return MethodResult.of((Object[])new Object[]{true, this.tileEntity.beehiveBlockEntity.m_58773_()});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getBees() {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        if (this.tileEntity.beehiveBlockEntity.m_58774_()) {
            return MethodResult.of((Object[])new Object[]{false, "there is no bees in the hive"});
        }
        ListTag bees = this.tileEntity.beehiveBlockEntity.m_58779_();
        HashMap data = new HashMap();
        for (int i = 0; i < bees.size(); ++i) {
            HashMap<String, Serializable> currentBeeData = new HashMap<String, Serializable>();
            CompoundTag bee = bees.m_128728_(i);
            currentBeeData.put("TicksInHive", Integer.valueOf(bee.m_128451_("TicksInHive")));
            currentBeeData.put("MinOccupationTicks", Integer.valueOf(bee.m_128451_("MinOccupationTicks")));
            CompoundTag entityData = bee.m_128469_("EntityData");
            HashMap<String, Comparable<Boolean>> currentBeeEntityData = new HashMap<String, Comparable<Boolean>>();
            currentBeeEntityData.put("HasStung", Boolean.valueOf(entityData.m_128471_("HasStung")));
            currentBeeEntityData.put("Health", Float.valueOf(entityData.m_128457_("Health")));
            currentBeeEntityData.put("HasNectar", Boolean.valueOf(entityData.m_128471_("HasNectar")));
            currentBeeEntityData.put("Age", Integer.valueOf(entityData.m_128451_("Age")));
            currentBeeEntityData.put("AngerTime", Integer.valueOf(entityData.m_128451_("AngerTime")));
            currentBeeData.put("EntityData", currentBeeEntityData);
            data.put(i + 1, currentBeeData);
        }
        return MethodResult.of((Object[])new Object[]{true, data});
    }

    @LuaFunction(mainThread=true)
    public MethodResult getHoneyLevel() {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        return MethodResult.of((Object[])new Object[]{true, this.tileEntity.beehive.m_61143_((Property)BeehiveBlock.f_49564_)});
    }

    @LuaFunction(mainThread=true)
    public MethodResult collectHoney(IComputerAccess computer, String resources, String to, boolean bottled) throws LuaException {
        if (this.hasMultipleBeehives()) {
            return MethodResult.of((Object[])new Object[]{false, "more than one beehive connected"});
        }
        if (!this.hasBeehive()) {
            return MethodResult.of((Object[])new Object[]{false, "no beehive present"});
        }
        if ((Integer)this.tileEntity.beehive.m_61143_((Property)BeehiveBlock.f_49564_) < 5) {
            return MethodResult.of((Object[])new Object[]{false, "there is not enough honey in the hive"});
        }
        IPeripheral input = computer.getAvailablePeripheral(resources);
        if (input == null) {
            throw new LuaException("the input " + resources + " was not found");
        }
        IItemHandler inputHandler = BeehiveInterfacePeripheral.extractHandler(input.getTarget());
        IPeripheral output = computer.getAvailablePeripheral(to);
        if (output == null) {
            throw new LuaException("the output " + to + " was not found");
        }
        IItemHandler outputHandler = BeehiveInterfacePeripheral.extractHandler(output.getTarget());
        ItemStack neededItem = ItemStack.f_41583_;
        int slot = -1;
        for (int i = 0; i < inputHandler.getSlots(); ++i) {
            if (bottled) {
                if (!inputHandler.getStackInSlot(i).m_150930_(Items.f_42590_)) continue;
                neededItem = inputHandler.getStackInSlot(i);
                slot = i;
                break;
            }
            if (!inputHandler.getStackInSlot(i).m_150930_(Items.f_42574_)) continue;
            neededItem = inputHandler.getStackInSlot(i);
            slot = i;
            break;
        }
        boolean passed = false;
        if (neededItem == ItemStack.f_41583_) {
            return MethodResult.of((Object[])new Object[]{false, "not found the needed item"});
        }
        if (neededItem.m_150930_(Items.f_42590_)) {
            inputHandler.extractItem(slot, 1, false);
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack outputStack = outputHandler.getStackInSlot(i);
                if (!outputStack.m_41619_() && (outputStack.m_41720_() != Items.f_42787_ || outputStack.m_41613_() >= outputStack.m_41741_())) continue;
                outputHandler.insertItem(i, Items.f_42787_.m_7968_(), false);
                passed = true;
                break;
            }
        } else if (neededItem.m_150930_(Items.f_42574_)) {
            ItemStack item = inputHandler.getStackInSlot(slot).m_41777_();
            inputHandler.extractItem(slot, 1, false);
            item.m_41721_(item.m_41773_() + 1);
            if (item.m_41773_() < item.m_41776_()) {
                inputHandler.insertItem(slot, item, false);
            }
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack outputStack = outputHandler.getStackInSlot(i);
                if (!outputStack.m_41619_() && (outputStack.m_41720_() != Items.f_42784_ || outputStack.m_41613_() >= outputStack.m_41741_())) continue;
                ItemStack stack = Items.f_42784_.m_7968_();
                stack.m_41764_(this.tileEntity.m_58904_().f_46441_.m_216339_(1, 4));
                outputHandler.insertItem(i, stack, false);
                passed = true;
                break;
            }
        }
        if (!passed) {
            return MethodResult.of((Object[])new Object[]{false, "the destination inventory is full"});
        }
        BlockState state = (BlockState)this.tileEntity.beehive.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0));
        BlockPos pos = this.tileEntity.beehiveBlockEntity.m_58899_();
        this.tileEntity.m_58904_().m_46597_(pos, state);
        return MethodResult.of((Object)true);
    }

    public boolean hasBeehive() {
        return this.tileEntity.beehiveBlockEntity != null;
    }

    public boolean hasMultipleBeehives() {
        return this.tileEntity.hasMultipleBeehives;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.beehiveInterface.get())) {
            BeehiveInterfacePeripheral peripheral = new BeehiveInterfacePeripheral();
            peripheral.tileEntity = (BeehiveInterfaceEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

