/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.DiskRaidEntity;
import com.hakimen.peripherals.registry.BlockRegister;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.core.util.StringUtil;
import dan200.computercraft.impl.MediaProviders;
import dan200.computercraft.shared.media.items.DiskItem;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskRaidPeripheral
implements IPeripheral,
IPeripheralProvider {
    private DiskRaidEntity tileEntity;

    @NotNull
    public String getType() {
        return "disk_raid";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public void attach(@NotNull IComputerAccess computer) {
        for (int i = 0; i < 5; ++i) {
            this.tileEntity.mount(i, computer);
        }
        super.attach(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        for (int i = 0; i < 5; ++i) {
            this.tileEntity.unmount(i, computer);
        }
        super.detach(computer);
    }

    @LuaFunction(mainThread=true)
    public final boolean isDiskPresent(int slot) {
        return !this.tileEntity.inventory.getStackInSlot(slot - 1).m_41619_();
    }

    @LuaFunction(mainThread=true)
    public final Object[] getDiskLabel(int slot) {
        Object[] objectArray;
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(slot - 1);
        IMedia media = MediaProviders.get((ItemStack)stack);
        if (media == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = media.getLabel(stack);
        }
        return objectArray;
    }

    @LuaFunction(mainThread=true)
    public final void setDiskLabel(int slot, Optional<String> labelA) throws LuaException {
        String label = labelA.orElse(null);
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(slot - 1);
        IMedia media = MediaProviders.get((ItemStack)stack);
        if (media == null) {
            return;
        }
        if (!media.setLabel(stack, StringUtil.normaliseLabel((String)label))) {
            throw new LuaException("Disk label cannot be changed");
        }
        this.tileEntity.inventory.extractItem(slot - 1, 1, false);
        this.tileEntity.inventory.insertItem(slot - 1, stack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    public final boolean hasData(int mount, IComputerAccess computer) {
        DiskRaidPeripheral diskRaidPeripheral = this;
        synchronized (diskRaidPeripheral) {
            DiskRaidEntity.MountInfo info = this.tileEntity.computers.get(computer);
            return (info != null ? info.mountPaths[mount] : null) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    @javax.annotation.Nullable
    public final String getMountPath(int mount, IComputerAccess computer) {
        DiskRaidPeripheral diskRaidPeripheral = this;
        synchronized (diskRaidPeripheral) {
            DiskRaidEntity.MountInfo info = this.tileEntity.computers.get(computer);
            return info != null ? info.mountPaths[mount] : null;
        }
    }

    @LuaFunction(mainThread=true)
    public final void ejectDisk(int slot) {
        this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)this.tileEntity.m_58899_().m_123341_(), (double)this.tileEntity.m_58899_().m_123342_(), (double)this.tileEntity.m_58899_().m_123343_(), this.tileEntity.inventory.extractItem(slot - 1, 1, false)));
    }

    @LuaFunction(mainThread=true)
    public final Object[] getDiskID(int slot) {
        Object[] objectArray;
        ItemStack disk = this.tileEntity.inventory.getStackInSlot(slot);
        if (disk.m_41720_() instanceof DiskItem) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = DiskItem.getDiskID((ItemStack)disk);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.diskRaid.get())) {
            DiskRaidPeripheral peripheral = new DiskRaidPeripheral();
            peripheral.tileEntity = (DiskRaidEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

