/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.EnderChestInterfaceBlock;
import com.hakimen.peripherals.blocks.tile_entities.EnderChestInterfaceEntity;
import com.hakimen.peripherals.items.PlayerCardItem;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderChestInterfacePeripheral
implements IPeripheral,
IPeripheralProvider {
    EnderChestInterfaceEntity entity;

    public String getType() {
        return "ender_chest_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public boolean hasCard() {
        return this.entity.inventory.getStackInSlot(0).m_41720_() instanceof PlayerCardItem;
    }

    public boolean cardIsBound() {
        return this.entity.inventory.getStackInSlot(0).m_41784_().m_128425_("Owner", 8);
    }

    public PlayerEnderChestContainer getEnderInventory() {
        UUID ownerUUID = this.entity.inventory.getStackInSlot(0).m_41784_().m_128342_("Bind");
        Player player = this.entity.m_58904_().m_46003_(ownerUUID);
        return player != null ? player.m_36327_() : null;
    }

    public Player getPlayer() {
        UUID ownerUUID = this.entity.inventory.getStackInSlot(0).m_41784_().m_128342_("Bind");
        Player player = this.entity.m_58904_().m_46003_(ownerUUID);
        return player;
    }

    @LuaFunction(mainThread=true)
    public MethodResult list() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        HashMap<Integer, Map> result = new HashMap<Integer, Map>();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return MethodResult.of(result);
    }

    @LuaFunction(mainThread=true)
    public MethodResult size() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        return MethodResult.of((Object)inventory.m_6643_());
    }

    @javax.annotation.Nullable
    @LuaFunction(mainThread=true)
    public MethodResult getItemDetail(int slot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        ItemStack stack = inventory.m_8020_(slot - 1);
        return MethodResult.of((Object)(stack.m_41619_() ? Boolean.valueOf(false) : VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack)));
    }

    @LuaFunction(mainThread=true)
    public MethodResult getItemLimit(int slot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        return MethodResult.of((Object)inventory.m_8020_(slot - 1).m_41741_());
    }

    @LuaFunction(mainThread=true)
    public MethodResult pushItems(IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStack inserted;
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = this.extractHandler(location.getTarget());
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)inventory.m_6643_(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)to.getSlots(), (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack extracted = inventory.m_7407_(fromSlot - 1, limit.orElse(1).intValue());
        if (toSlot.isPresent() && to.isItemValid(toSlot.get().intValue(), extracted)) {
            ItemStack inserted2 = to.insertItem(toSlot.get() - 1, extracted, false);
            if (inserted2.m_41613_() == 0) {
                return MethodResult.of((Object)extracted.m_41613_());
            }
            inventory.m_19173_(inserted2);
            return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + (toSlot.get() - 1)});
        }
        for (int i = 0; i < to.getSlots() && (inserted = to.insertItem(i, extracted, false)).m_41613_() != 0; ++i) {
            if (i != to.getSlots() - 1 || inserted.m_41613_() <= 0) continue;
            inventory.m_19173_(inserted);
            return MethodResult.of((Object[])new Object[]{false, "Couldn't move items"});
        }
        return MethodResult.of((Object)extracted.m_41613_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(mainThread=true)
    public MethodResult pullItems(IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        PlayerEnderChestContainer inventory = this.getEnderInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = this.extractHandler(location.getTarget());
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)from.getSlots(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)inventory.m_6643_(), (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack extracted = from.extractItem(fromSlot - 1, limit.orElse(1).intValue(), true);
        int count = extracted.m_41613_();
        if (!inventory.m_19183_(extracted)) return MethodResult.of((Object[])new Object[]{false, "Ender chest is full"});
        extracted = from.extractItem(fromSlot - 1, limit.orElse(1).intValue(), false);
        if (toSlot.isPresent()) {
            ItemStack itemInSlot = inventory.m_8020_(toSlot.get() - 1);
            boolean canPlace = false;
            ItemStack placeStack = ItemStack.f_41583_;
            if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)ItemStack.f_41583_)) {
                canPlace = true;
                placeStack = extracted;
            } else if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)extracted) && itemInSlot.m_41613_() + extracted.m_41613_() <= itemInSlot.m_41741_()) {
                canPlace = true;
                placeStack = itemInSlot;
                placeStack.m_41764_(itemInSlot.m_41613_() + extracted.m_41613_());
            }
            if (!canPlace) return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + toSlot.get()});
            inventory.m_6836_(toSlot.get() - 1, placeStack);
            return MethodResult.of((Object)count);
        } else {
            inventory.m_19173_(extracted);
        }
        return MethodResult.of((Object)count);
    }

    @javax.annotation.Nullable
    private IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ForgeContainerTransfer fromWrapper = new ForgeContainerTransfer(from).singleSlot(fromSlot);
        ForgeContainerTransfer toWrapper = new ForgeContainerTransfer(to);
        if (toSlot >= 0) {
            toWrapper = toWrapper.singleSlot(toSlot);
        }
        return Math.max(0, fromWrapper.moveTo((ContainerTransfer)toWrapper, limit));
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_() instanceof EnderChestInterfaceBlock) {
            EnderChestInterfacePeripheral playerInt = new EnderChestInterfacePeripheral();
            playerInt.entity = (EnderChestInterfaceEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> playerInt);
        }
        return LazyOptional.empty();
    }
}

